/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.dialog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.mule.tooling.client.api.PropagationInfo;
import org.mule.tooling.core.ModelUtils;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.dialog.PropagationJobsHolder;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.editor.MultiPageMessageFlowEditor;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.metadata.SideToSideMetadataTreeExplorer;
import org.mule.tooling.messageflow.util.DefaultMuleConfigurationLabelProvider;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.messageflow.util.MuleConfigurationContentProvider;
import org.mule.tooling.metadata.custom.metadata.assistant.CustomMetadataAssistantService;
import org.mule.tooling.metadata.custom.metadata.assistant.MetadataActualExpectedParametersContainer;
import org.mule.tooling.metadata.datasense.DataSenseJob;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.path.MulePath;
import org.mule.tooling.ui.MuleImages;
import org.mule.tooling.ui.widgets.progress.bar.ProgressBarMonitor;
import org.mule.tooling.ui.widgets.util.ThemeUtils;

public class ExtractEntityToNewFlowDialog
extends Dialog {
    private static final String COMBO_TOOLTIP = "The mule configuration that will contain the extracted flow.";
    private static final String LOADING_METADATA_LABEL = "Loading metadata";
    private static final String WARNING_LABEL = "The flow's metadata will be set as custom metadata only for this flow. If you make changes, you should set up the\nflow's metadata again. <a>Learn More</a>";
    private Text text;
    private String flowName;
    private static final String SHELLNAME = "Extract Flow";
    private static final String FLOW_NAME_LABEL_TEXT = "Flow name: ";
    private MessageFlowEditor flowEditor;
    private MuleConfiguration selectedMuleConfiguration;
    private MuleConfiguration currentMuleConfiguration;
    private CustomMetadataAssistantService customMetadataAssistantService;
    private boolean advancedOptionsUsed;
    private PropagationJobsHolder propagationJobs;
    private SideToSideMetadataTreeExplorer metadataTreeExplorer;
    private static final String ELEMENT_DATA_KEY = "ID";
    private static final String ELEMENT_DATA_VALUE = "disposable";
    private static final String BUTTON_OPEN_TEXT = "Metadata Preferences <<";
    private static final String BUTTON_CLOSED_TEXT = "Metadata Preferences >>";
    private MetadataActualExpectedParametersContainer preferenceContainer;
    private Composite mainComposite;
    private static final String ERROR_TEXT = "Flow's name already exists";
    private ControlDecoration txtDecorator;
    private static final String MISSING_DOC_ID_WARNING = "doc:id required for propagation";

    public ExtractEntityToNewFlowDialog(Shell parentShell, String flowName, CustomMetadataAssistantService customMetadataAssistantService) {
        super(parentShell);
        this.setFlowName(flowName);
        this.setFlowEditor(MessageFlowUtils.getFlowEditorFromActivePage());
        this.currentMuleConfiguration = (MuleConfiguration)this.getFlowEditor().getModelRoot().getEntity();
        this.customMetadataAssistantService = customMetadataAssistantService;
        this.advancedOptionsUsed = Boolean.FALSE;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(SHELLNAME);
    }

    protected Point getInitialLocation(Point initialSize) {
        Point initialLocation = super.getInitialLocation(initialSize);
        initialLocation.y -= 120;
        return initialLocation;
    }

    protected Control createDialogArea(Composite parent) {
        GridDataFactory gridDataFactory = GridDataFactory.fillDefaults().align(4, 0x1000000).hint(480, -1).indent(6, 6).span(1, 1).grab(true, false);
        this.mainComposite = (Composite)super.createDialogArea(parent);
        this.mainComposite.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        this.mainComposite.setLayoutData((Object)gridData);
        Label flowNameLabel = new Label(this.mainComposite, 0);
        GridDataFactory.fillDefaults().align(1, 0x1000000).indent(6, 6).span(1, 1).grab(false, false).applyTo((Control)flowNameLabel);
        flowNameLabel.setText(FLOW_NAME_LABEL_TEXT);
        this.text = new Text(this.mainComposite, 2048);
        gridDataFactory.applyTo((Control)this.text);
        this.txtDecorator = new ControlDecoration((Control)this.text, 0x1004000);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        this.txtDecorator.setImage(fieldDecoration.getImage());
        this.txtDecorator.setDescriptionText(ERROR_TEXT);
        this.txtDecorator.hide();
        this.txtDecorator.setShowHover(true);
        this.txtDecorator.setMarginWidth(5);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                if (ExtractEntityToNewFlowDialog.this.text.getText().isEmpty()) {
                    ExtractEntityToNewFlowDialog.this.getButton(0).setEnabled(false);
                } else {
                    ExtractEntityToNewFlowDialog.this.setFlowName(ExtractEntityToNewFlowDialog.this.text.getText());
                    ExtractEntityToNewFlowDialog.this.getButton(0).setEnabled(true);
                }
                ExtractEntityToNewFlowDialog.this.validateThatFlowNameDoesNotExist();
            }
        });
        Label targetMuleConfigLabel = new Label(this.mainComposite, 0);
        GridDataFactory.fillDefaults().align(1, 0x1000000).indent(6, 6).span(1, 1).grab(false, false).applyTo((Control)targetMuleConfigLabel);
        targetMuleConfigLabel.setText("Target Mule Configuration:");
        this.generateComboBox(this.mainComposite, gridDataFactory);
        return this.mainComposite;
    }

    protected void okPressed() {
        if (!this.currentMuleConfiguration.equals(this.selectedMuleConfiguration)) {
            this.openAndUpdateTargetConfiguration();
        }
        if (this.advancedOptionsUsed) {
            this.calculatesPropagationPreferences();
        } else {
            this.fillMetadataPropagationJobs(this.getFlowEditor().hasMultipleSelectedEntities());
        }
        super.okPressed();
    }

    private void openAndUpdateTargetConfiguration() {
        IMuleProject muleProject = MessageFlowUtils.getMultiPageMessageFlowEditor().getMuleProject();
        Optional<MultiPageMessageFlowEditor> multiPageEditorForFile = MessageFlowUtils.getOrOpenMultiPageEditorFor(this.selectedMuleConfiguration, muleProject);
        this.selectedMuleConfiguration = multiPageEditorForFile.map(editor -> editor.getMuleConfiguration()).orElseThrow(() -> new IllegalStateException("failed to get or open the editor for mule configuration " + String.valueOf(this.selectedMuleConfiguration)));
    }

    private Composite generateLabelGroup(Composite parent) {
        Composite group = new Composite(parent, 2048);
        group.setData(ELEMENT_DATA_KEY, (Object)ELEMENT_DATA_VALUE);
        GridData gridDataGroup = new GridData(4, 16384, false, false, 2, 1);
        gridDataGroup.horizontalIndent = 6;
        group.setLayoutData((Object)gridDataGroup);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setBackground(new Color(255, 255, 255));
        group.setBackgroundMode(0);
        Label label2 = new Label(group, 32);
        label2.setImage(MuleImages.WARN_EDITOR_IMAGE);
        label2.setBackground(new Color(255, 255, 255));
        Link link = new Link(group, 0);
        link.setText(WARNING_LABEL);
        link.setBackground(new Color(255, 255, 255));
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    Program.launch((String)"https://docs.mulesoft.com/studio/latest/metadata-propagation-between-flows");
                }
                catch (Exception exception) {}
            }
        });
        return group;
    }

    private void generateComboBox(Composite composite, GridDataFactory grab) {
        final ComboViewer targetMuleConfigCombo = new ComboViewer(composite, 524);
        targetMuleConfigCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        targetMuleConfigCombo.setContentProvider((IContentProvider)new MuleConfigurationContentProvider());
        targetMuleConfigCombo.setLabelProvider((IBaseLabelProvider)new DefaultMuleConfigurationLabelProvider());
        targetMuleConfigCombo.setInput((Object)this.getFlowEditor().getMuleProject());
        targetMuleConfigCombo.getCombo().setToolTipText(COMBO_TOOLTIP);
        targetMuleConfigCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)targetMuleConfigCombo.getSelection();
                if (selection.size() > 0) {
                    MuleConfiguration selected = (MuleConfiguration)selection.getFirstElement();
                    targetMuleConfigCombo.getCombo().setText(selected.getName());
                    ExtractEntityToNewFlowDialog.this.selectedMuleConfiguration = selected;
                }
            }
        });
        targetMuleConfigCombo.getCombo().setText("Current");
        GridData data = grab.create();
        data.horizontalIndent = 3;
        targetMuleConfigCombo.getControl().setLayoutData((Object)data);
        this.selectedMuleConfiguration = this.currentMuleConfiguration;
    }

    public void calculatesPropagationPreferences() {
        MetadataActualExpectedParametersContainer metadataActualExpectedParametersContainer = this.preferenceContainer = this.metadataTreeExplorer != null && this.preferenceContainer == null ? this.metadataTreeExplorer.getPropagationPreference() : this.preferenceContainer;
        if (this.preferenceContainer == null) {
            this.fillMetadataPropagationJobs(this.getFlowEditor().hasMultipleSelectedEntities());
            PropagationInfo firstElement = this.propagationJobs.getFirst().joinAndGetPropagationInfo();
            PropagationInfo lastElement = this.propagationJobs.getLast().joinAndGetPropagationInfo();
            this.preferenceContainer = this.customMetadataAssistantService.getActualExpectedMetadataParametersContainer(firstElement, lastElement);
        }
    }

    public MetadataActualExpectedParametersContainer getPreferenceContainer() {
        return this.metadataTreeExplorer != null && this.preferenceContainer == null ? this.metadataTreeExplorer.getPropagationPreference() : this.preferenceContainer;
    }

    public MetadataActualExpectedParametersContainer getPropagationPreferences() {
        this.calculatesPropagationPreferences();
        return this.preferenceContainer;
    }

    private void fillMetadataPropagationJobs(boolean moreThanOneOperationSelected) {
        if (moreThanOneOperationSelected) {
            List flowItems = this.getFlowEditor().getSelectedEntities().get().toList().stream().filter(element -> !ModelUtils.isComment(((EntityEditPart)element).getEntity())).map(element -> new FlowItem(this.currentMuleConfiguration.getPathFor(((EntityEditPart)element).getEntity()).toString(), (IMessageFlowEntity)((EntityEditPart)element).getEntity())).collect(Collectors.toList());
            Collections.sort(flowItems);
            IMessageFlowEntity firstEntity = ((FlowItem)flowItems.get(0)).getEntity();
            IMessageFlowEntity lastEntity = ((FlowItem)flowItems.get(flowItems.size() - 1)).getEntity();
            MulePath originMulePathFirst = this.currentMuleConfiguration.getPathFor(firstEntity);
            MulePath originMulePathLast = this.currentMuleConfiguration.getPathFor(lastEntity);
            DataSenseJob propagationInfoFirst = this.customMetadataAssistantService.getMetadataPropagationJob(this.currentMuleConfiguration, originMulePathFirst);
            DataSenseJob propagationInfoLast = this.customMetadataAssistantService.getMetadataPropagationJob(this.currentMuleConfiguration, originMulePathLast);
            this.propagationJobs = new PropagationJobsHolder(propagationInfoFirst, propagationInfoLast);
        } else {
            MulePath originMulePath = this.currentMuleConfiguration.getPathFor(this.getFlowEditor().getSelectedEntity().get().getEntity());
            this.propagationJobs = new PropagationJobsHolder(this.customMetadataAssistantService.getMetadataPropagationJob(this.currentMuleConfiguration, originMulePath));
        }
    }

    public void setText(Text text) {
        this.text = text;
    }

    public Text getText() {
        return this.text;
    }

    public void setFlowName(String flowName) {
        this.flowName = flowName;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public void setFlowEditor(MessageFlowEditor flowEditor) {
        this.flowEditor = flowEditor;
    }

    public MessageFlowEditor getFlowEditor() {
        return this.flowEditor;
    }

    public MuleConfiguration getSelectedMuleConfiguration() {
        return this.selectedMuleConfiguration;
    }

    public boolean getAdvancedOptionsUsed() {
        return this.advancedOptionsUsed;
    }

    public PropagationJobsHolder getPropagationJobs() {
        return this.propagationJobs;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        final Button metadataPropagationAdvanceModeButton = this.createButton(parent, 100, BUTTON_CLOSED_TEXT, false);
        metadataPropagationAdvanceModeButton.setText(BUTTON_CLOSED_TEXT);
        metadataPropagationAdvanceModeButton.setToolTipText(BUTTON_CLOSED_TEXT);
        boolean showDocIdMissingAlert = this.getElementsToValidateDocID().stream().anyMatch(element -> this.customMetadataAssistantService.isDocIdMissing(element));
        if (showDocIdMissingAlert) {
            CLabel label = new CLabel(parent, 0);
            label.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
            label.setImage(ThemeUtils.getCurrentTheme().getInfoImageIcon());
            label.setText(MISSING_DOC_ID_WARNING);
            label.setToolTipText(MISSING_DOC_ID_WARNING);
        } else {
            Label spacer = new Label(parent, 0);
            spacer.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        }
        GridLayout layout = (GridLayout)parent.getLayout();
        ++layout.numColumns;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 5;
        metadataPropagationAdvanceModeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!ExtractEntityToNewFlowDialog.this.advancedOptionsUsed) {
                    metadataPropagationAdvanceModeButton.setText(ExtractEntityToNewFlowDialog.BUTTON_OPEN_TEXT);
                    metadataPropagationAdvanceModeButton.setToolTipText(ExtractEntityToNewFlowDialog.BUTTON_OPEN_TEXT);
                    Composite labelWarningGroup = ExtractEntityToNewFlowDialog.this.generateLabelGroup(ExtractEntityToNewFlowDialog.this.mainComposite);
                    ExtractEntityToNewFlowDialog.this.metadataTreeExplorer = new SideToSideMetadataTreeExplorer(ExtractEntityToNewFlowDialog.this.mainComposite, 0, ExtractEntityToNewFlowDialog.this.customMetadataAssistantService);
                    ExtractEntityToNewFlowDialog.this.metadataTreeExplorer.setData(ExtractEntityToNewFlowDialog.ELEMENT_DATA_KEY, ExtractEntityToNewFlowDialog.ELEMENT_DATA_VALUE);
                    Label loadingMetadataLabel = new Label(ExtractEntityToNewFlowDialog.this.mainComposite, 0);
                    loadingMetadataLabel.setData(ExtractEntityToNewFlowDialog.ELEMENT_DATA_KEY, (Object)ExtractEntityToNewFlowDialog.ELEMENT_DATA_VALUE);
                    GridDataFactory.fillDefaults().align(1, 0x1000000).span(6, 1).grab(true, false).applyTo((Control)loadingMetadataLabel);
                    loadingMetadataLabel.setText(ExtractEntityToNewFlowDialog.LOADING_METADATA_LABEL);
                    ProgressBar metadataLoadingBar = new ProgressBar(ExtractEntityToNewFlowDialog.this.mainComposite, 0);
                    metadataLoadingBar.setData(ExtractEntityToNewFlowDialog.ELEMENT_DATA_KEY, (Object)ExtractEntityToNewFlowDialog.ELEMENT_DATA_VALUE);
                    GridData gridDataLoadingBar = new GridData(1808);
                    gridDataLoadingBar.horizontalSpan = 4;
                    gridDataLoadingBar.grabExcessHorizontalSpace = Boolean.TRUE;
                    metadataLoadingBar.setLayoutData((Object)gridDataLoadingBar);
                    metadataLoadingBar.setBackground(ColorConstants.black);
                    ProgressBarMonitor progressBarMonitor = new ProgressBarMonitor(metadataLoadingBar);
                    ExtractEntityToNewFlowDialog.this.mainComposite.getShell().pack(true);
                    ExtractEntityToNewFlowDialog.this.advancedOptionsUsed = Boolean.TRUE;
                    metadataLoadingBar.setVisible(Boolean.TRUE.booleanValue());
                    labelWarningGroup.setVisible(Boolean.TRUE.booleanValue());
                    progressBarMonitor.beginTask("metadata extraction", 100);
                    Display.getDefault().asyncExec(() -> {
                        progressBarMonitor.worked(60);
                        boolean hasMultipleEntities = ExtractEntityToNewFlowDialog.this.getFlowEditor().hasMultipleSelectedEntities();
                        ExtractEntityToNewFlowDialog.this.fillMetadataPropagationJobs(hasMultipleEntities);
                        PropagationInfo firstElement = ExtractEntityToNewFlowDialog.this.propagationJobs.getFirst().joinAndGetPropagationInfo();
                        if (hasMultipleEntities) {
                            PropagationInfo lastElement = ExtractEntityToNewFlowDialog.this.propagationJobs.getLast().joinAndGetPropagationInfo();
                            ExtractEntityToNewFlowDialog.this.metadataTreeExplorer.updateMetadata(firstElement, lastElement);
                        } else {
                            ExtractEntityToNewFlowDialog.this.metadataTreeExplorer.updateMetadata(firstElement);
                        }
                        progressBarMonitor.worked(40);
                        progressBarMonitor.done();
                        ExtractEntityToNewFlowDialog.this.metadataTreeExplorer.setTabSelectionToZero();
                        loadingMetadataLabel.setVisible(false);
                        metadataLoadingBar.setVisible(false);
                    });
                } else {
                    metadataPropagationAdvanceModeButton.setText(ExtractEntityToNewFlowDialog.BUTTON_CLOSED_TEXT);
                    metadataPropagationAdvanceModeButton.setToolTipText(ExtractEntityToNewFlowDialog.BUTTON_CLOSED_TEXT);
                    ExtractEntityToNewFlowDialog.this.advancedOptionsUsed = Boolean.FALSE;
                    Arrays.asList(ExtractEntityToNewFlowDialog.this.mainComposite.getChildren()).forEach(child -> {
                        if (child.getData(ExtractEntityToNewFlowDialog.ELEMENT_DATA_KEY) != null && child.getData(ExtractEntityToNewFlowDialog.ELEMENT_DATA_KEY).equals(ExtractEntityToNewFlowDialog.ELEMENT_DATA_VALUE)) {
                            child.dispose();
                        }
                    });
                    ExtractEntityToNewFlowDialog.this.mainComposite.getShell().pack(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.getButton(0).setEnabled(false);
    }

    private void validateThatFlowNameDoesNotExist() {
        List configs = this.getFlowEditor().getMuleProject().getConfigurationsCache().getConfigurations();
        ArrayList flows = new ArrayList();
        configs.forEach(config -> {
            boolean bl = flows.addAll(config.getFlows());
        });
        boolean flowNameExists = flows.stream().anyMatch(flow -> flow.getName().equals(this.text.getText()));
        if (flowNameExists) {
            this.txtDecorator.show();
            this.getButton(0).setEnabled(false);
        } else {
            this.getButton(0).setEnabled(true);
            this.txtDecorator.hide();
        }
    }

    private List<IElementWrapper> getElementsToValidateDocID() {
        ArrayList<IElementWrapper> elements = new ArrayList<IElementWrapper>();
        if (this.getFlowEditor().hasMultipleSelectedEntities().booleanValue()) {
            List flowItems = this.getFlowEditor().getSelectedEntities().get().toList().stream().filter(element -> !ModelUtils.isComment(((EntityEditPart)element).getEntity())).map(element -> new FlowItem(this.currentMuleConfiguration.getPathFor(((EntityEditPart)element).getEntity()).toString(), (IMessageFlowEntity)((EntityEditPart)element).getEntity())).collect(Collectors.toList());
            Collections.sort(flowItems);
            IMessageFlowEntity firstEntity = ((FlowItem)flowItems.get(0)).getEntity();
            IMessageFlowEntity lastEntity = ((FlowItem)flowItems.get(flowItems.size() - 1)).getEntity();
            elements.add(firstEntity.getElement());
            elements.add(lastEntity.getElement());
        } else {
            elements.add(this.getFlowEditor().getSelectedEntity().get().getEntity().getElement());
        }
        return elements;
    }

    private class FlowItem
    implements Comparable<FlowItem> {
        private String mulePath;
        private IMessageFlowEntity entity;

        public FlowItem(String mulePath, IMessageFlowEntity entity) {
            this.mulePath = mulePath;
            this.entity = entity;
        }

        public IMessageFlowEntity getEntity() {
            return this.entity;
        }

        @Override
        public int compareTo(FlowItem o) {
            return this.mulePath.compareTo(o.mulePath);
        }
    }
}

