/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.dialog;

import java.util.Optional;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.client.api.PropagationInfo;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.dialog.ExportMetadataConfirmationDialog;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.metadata.SideToSideMetadataTreeExplorer;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.metadata.custom.metadata.assistant.CustomMetadataAssistantService;
import org.mule.tooling.metadata.custom.metadata.assistant.MetadataActualExpectedParametersContainer;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.path.MulePath;
import org.mule.tooling.ui.MuleImages;
import org.mule.tooling.ui.widgets.progress.bar.ProgressBarMonitor;

public class ExportMetadataToFlowRefDialog
extends Dialog {
    private static final String CUSTOM_METADATA_LABEL = "Custom Metadata";
    private static final String LOADING_METADATA_LABEL = "Loading metadata";
    private MessageFlowEditor flowEditor;
    private MuleConfiguration selectedMuleConfiguration;
    private MuleConfiguration currentMuleConfiguration;
    private CustomMetadataAssistantService customMetadataAssistantService;
    private Boolean exportData;
    private PropagationInfo propagationInfo;
    private SideToSideMetadataTreeExplorer metadataTreeExplorer;
    private ProgressBar metadataLoadingBar;
    private MulePath originPath;
    private String content = "";
    private Label loadingMetadataLabel;
    private ExportMetadataConfirmationDialog parentDialog;
    private String eventKey;
    private static final String WARNING_LABEL = "The flow's metadata will be set as custom metadata only for this flow. If you make changes, you should set up the\nflow's metadata again. <a>Learn More</a>";
    private Container targetContainer;

    public ExportMetadataToFlowRefDialog(Shell parentShell, CustomMetadataAssistantService customMetadataAssistantService, Container targetContiner, MulePath originPath, String content, String eventKey) {
        super(parentShell);
        this.setFlowEditor(MessageFlowUtils.getFlowEditorFromActivePage());
        this.customMetadataAssistantService = customMetadataAssistantService;
        this.exportData = Boolean.FALSE;
        this.targetContainer = targetContiner;
        this.originPath = originPath;
        this.content = content;
        this.eventKey = eventKey;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(CUSTOM_METADATA_LABEL);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gridData);
        Label contentLabel = new Label(composite, 0);
        GridData contentGridData = GridDataFactory.fillDefaults().align(1, 0x1000000).indent(6, 0).span(2, 7).grab(true, false).create();
        contentLabel.setLayoutData((Object)contentGridData);
        contentLabel.setText(this.content);
        this.generateLabelGroup(composite).pack();
        this.metadataTreeExplorer = new SideToSideMetadataTreeExplorer(composite, 0, this.customMetadataAssistantService);
        this.loadingMetadataLabel = new Label(composite, 0);
        GridDataFactory.fillDefaults().align(1, 0x1000000).indent(6, 6).span(2, 2).grab(false, false).applyTo((Control)this.loadingMetadataLabel);
        this.loadingMetadataLabel.setText(LOADING_METADATA_LABEL);
        this.metadataLoadingBar = new ProgressBar(composite, 0);
        this.metadataLoadingBar.setBounds(100, 10, 200, 20);
        GridDataFactory.fillDefaults().align(4, 1).span(3, 1).indent(6, 6).grab(true, false).applyTo((Control)this.metadataLoadingBar);
        this.importMetadata();
        return composite;
    }

    protected void okPressed() {
        this.propagationInfo = this.customMetadataAssistantService.getMetadataPropagationJob(this.currentMuleConfiguration, this.originPath).joinAndGetPropagationInfo();
        MetadataActualExpectedParametersContainer preferencesContainer = this.metadataTreeExplorer.getPropagationPreference();
        Optional<EntityEditPart<?>> entityOptional = MessageFlowUtils.getFlowEditorFromActivePage().getSelectedEntity();
        IElementWrapper originFlowElement = entityOptional.get().getEntity().getElement();
        this.customMetadataAssistantService.translatePersistAndAssignMetadata(this.propagationInfo, this.propagationInfo, originFlowElement, preferencesContainer, (MessageFlowNode)this.targetContainer, true);
        AnalyticsRecordsFactory.single((String)this.eventKey, (IMuleProject)MessageFlowUtils.getFlowEditorFromActivePage().getMuleProject()).track();
        this.parentDialog.setChildOpen(Boolean.FALSE);
        super.okPressed();
    }

    protected void cancelPressed() {
        this.parentDialog.setChildOpen(Boolean.FALSE);
        super.cancelPressed();
    }

    private void importMetadata() {
        MessageFlowUtils.getFlowEditorFromActivePage().reload();
        this.currentMuleConfiguration = (MuleConfiguration)this.getFlowEditor().getModelRoot().getEntity();
        this.exportData = Boolean.TRUE;
        ProgressBarMonitor progressBarMonitor = new ProgressBarMonitor(this.metadataLoadingBar);
        progressBarMonitor.beginTask("metadata extraction", 100);
        Display.getDefault().asyncExec(() -> {
            progressBarMonitor.worked(40);
            this.propagationInfo = this.customMetadataAssistantService.getMetadataPropagationJob(this.currentMuleConfiguration, this.originPath).joinAndGetPropagationInfo();
            progressBarMonitor.worked(20);
            this.metadataTreeExplorer.updateMetadata(this.propagationInfo);
            this.metadataTreeExplorer.setVisible(Boolean.TRUE);
            this.metadataLoadingBar.setVisible(Boolean.FALSE.booleanValue());
            this.loadingMetadataLabel.setVisible(Boolean.FALSE.booleanValue());
            this.metadataTreeExplorer.setTabSelectionToZero();
            this.metadataTreeExplorer.getChildren()[0].forceFocus();
            progressBarMonitor.worked(40);
            progressBarMonitor.done();
        });
    }

    private Composite generateLabelGroup(Composite parent) {
        Composite group = new Composite(parent, 2048);
        GridData gridDataGroup = new GridData(4, 16384, false, false, 2, 1);
        gridDataGroup.horizontalIndent = 6;
        group.setLayoutData((Object)gridDataGroup);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setBackground(new Color(255, 255, 255));
        group.setBackgroundMode(0);
        Label label2 = new Label(group, 32);
        label2.setImage(MuleImages.WARN_EDITOR_IMAGE);
        label2.setBackground(new Color(255, 255, 255));
        Link link = new Link(group, 0);
        link.setText(WARNING_LABEL);
        link.setBackground(new Color(255, 255, 255));
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    Program.launch((String)"https://docs.mulesoft.com/studio/latest/metadata-propagation-between-flows");
                }
                catch (Exception exception) {}
            }
        });
        return group;
    }

    public void setFlowEditor(MessageFlowEditor flowEditor) {
        this.flowEditor = flowEditor;
    }

    public MessageFlowEditor getFlowEditor() {
        return this.flowEditor;
    }

    public MuleConfiguration getSelectedMuleConfiguration() {
        return this.selectedMuleConfiguration;
    }

    public Boolean getExportData() {
        return this.exportData;
    }

    public PropagationInfo getPropagationInfo() {
        return this.propagationInfo;
    }

    public void setParentDialog(ExportMetadataConfirmationDialog parentDialog) {
        this.parentDialog = parentDialog;
    }
}

