/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.dialog;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.metadata.custom.metadata.assistant.CustomMetadataAssistantService;
import org.mule.tooling.metadata.datasense.DataSenseJob;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.path.MulePath;
import org.mule.tooling.ui.MuleImages;

public class ExportMetadataConfirmationDialog
extends Dialog {
    private static final String CUSTOMIZE_BUTTON_TEXT = "Customize";
    private MessageFlowEditor flowEditor;
    private Label contentLabel;
    private Label imageLabel;
    private Boolean childOpen = Boolean.FALSE;
    private String title = "Custom metadata is not set";
    private String mainText;
    private Boolean open;
    private Dialog childDialog;
    private final int CUSTOMIZE_ID = 100;
    private CustomMetadataAssistantService customMetadataAssistantService;
    private MulePath originPath;
    private String eventKey;
    private Container targetContainer;

    public ExportMetadataConfirmationDialog(Shell parentShell, Dialog childDialog, String mainText, String title, CustomMetadataAssistantService customMetadataAssistantService, Container targetContainer, MulePath originPath, String eventKey) {
        super(parentShell);
        this.setFlowEditor(MessageFlowUtils.getFlowEditorFromActivePage());
        this.childDialog = childDialog;
        this.mainText = mainText;
        this.title = title;
        this.open = Boolean.FALSE;
        this.customMetadataAssistantService = customMetadataAssistantService;
        this.originPath = originPath;
        this.eventKey = eventKey;
        this.targetContainer = targetContainer;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button button = this.createButton(parent, 100, CUSTOMIZE_BUTTON_TEXT, false);
        button.setToolTipText(CUSTOMIZE_BUTTON_TEXT);
        Label spacer = new Label(parent, 0);
        spacer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout layout = (GridLayout)parent.getLayout();
        ++layout.numColumns;
        layout.makeColumnsEqualWidth = false;
        this.createButton(parent, 1, IDialogConstants.NO_LABEL, false);
        this.createButton(parent, 0, IDialogConstants.YES_LABEL, true);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExportMetadataConfirmationDialog.this.childOpen = Boolean.TRUE;
                ExportMetadataConfirmationDialog.this.open = Boolean.FALSE;
                ExportMetadataConfirmationDialog.this.childDialog.open();
                ExportMetadataConfirmationDialog.this.cancelPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(1808);
        gridData.widthHint = 400;
        composite.setLayoutData((Object)gridData);
        this.imageLabel = new Label(composite, 0);
        Image image = MuleImages.ALERT_NOTE_IMAGE;
        ImageData imageData = image.getImageData();
        Image modifiedImage = new Image((Device)this.getShell().getDisplay(), imageData);
        this.imageLabel.setImage(modifiedImage);
        GridDataFactory.fillDefaults().align(1, 0x1000000).indent(10, 0).span(1, 2).grab(false, true).applyTo((Control)this.imageLabel);
        this.contentLabel = new Label(composite, 0);
        GridDataFactory.fillDefaults().align(1, 1024).indent(6, 20).span(1, 1).grab(false, false).applyTo((Control)this.contentLabel);
        this.contentLabel.setText(this.title);
        Label explanationLabel = new Label(composite, 64);
        explanationLabel.setText(this.mainText);
        GridData explanationLabelData = GridDataFactory.fillDefaults().align(1, 1024).indent(6, 10).span(1, 2).grab(true, true).create();
        explanationLabelData.widthHint = 500;
        explanationLabel.setLayoutData((Object)explanationLabelData);
        Font font = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
        FontData data = font.getFontData()[0];
        data.setHeight(16);
        font = new Font(font.getDevice(), data);
        this.contentLabel.setFont(font);
        return composite;
    }

    public int open() {
        this.open = Boolean.TRUE;
        int id = super.open();
        return id;
    }

    protected void okPressed() {
        MessageFlowUtils.getFlowEditorFromActivePage().reload();
        DataSenseJob propagationJob = this.customMetadataAssistantService.getMetadataPropagationJob((MuleConfiguration)this.getFlowEditor().getModelRoot().getEntity(), this.originPath);
        Object originEntity = MessageFlowUtils.getFlowEditorFromActivePage().getSelectedEntity().get().getEntity();
        this.customMetadataAssistantService.resolveTranslatePersistAndAssignMetadata(propagationJob, propagationJob, originEntity.getElement(), (MessageFlowNode)this.targetContainer, true);
        AnalyticsRecordsFactory.single((String)this.eventKey, (IMuleProject)this.flowEditor.getMuleProject()).track();
        super.okPressed();
    }

    protected void cancelPressed() {
        this.childOpen = Boolean.FALSE;
        super.cancelPressed();
    }

    public boolean close() {
        this.open = Boolean.FALSE;
        return super.close();
    }

    public void setFlowEditor(MessageFlowEditor flowEditor) {
        this.flowEditor = flowEditor;
    }

    public MessageFlowEditor getFlowEditor() {
        return this.flowEditor;
    }

    public Dialog getChildDialog() {
        return this.childDialog;
    }

    public Boolean getChildOpen() {
        return this.childOpen;
    }

    public void setChildOpen(Boolean isOpen) {
        this.childOpen = isOpen;
    }

    public Boolean getOpen() {
        return this.open;
    }
}

