/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.dialog;

import java.io.File;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.editor.MultiPageMessageFlowEditor;
import org.mule.tooling.messageflow.editpart.MuleConfigurationEditPart;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.decorator.MuleConfigurationDecorator;

public class ExportImageToFileHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String fileSelected;
        IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        MultiPageMessageFlowEditor editor = (MultiPageMessageFlowEditor)activeEditor;
        MessageFlowEditor messageFlowEditor = editor.getFlowEditor();
        MuleConfigurationDecorator muleConfigurationDecorator = messageFlowEditor.getMuleConfigurationDecorator();
        GraphicalViewer viewer = MessageFlowUtils.createViewer(messageFlowEditor.getMuleProject(), muleConfigurationDecorator);
        MuleConfigurationEditPart muleConfigurationEditPart = (MuleConfigurationEditPart)MessageFlowEditor.findEditPartInRegistry((EditPartViewer)viewer, muleConfigurationDecorator.getEntity());
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        FileDialog dialog = new FileDialog(shell, 8192);
        dialog.setOverwrite(true);
        dialog.setFilterExtensions(new String[]{"png", "jpg", "bmp"});
        if (messageFlowEditor.getMuleProject() != null) {
            dialog.setFileName(messageFlowEditor.getMuleProject().getName());
        }
        if ((fileSelected = dialog.open()) != null) {
            boolean confirmation;
            File outputFile = new File(fileSelected);
            if (outputFile.exists() && !(confirmation = MessageDialog.openQuestion((Shell)dialog.getParent(), (String)"Confirmation", (String)(outputFile.getAbsolutePath() + " already exists.\nDo you want to overwrite it?")))) {
                return null;
            }
            Image resultImage = MessageFlowUtils.getImageToExport(muleConfigurationEditPart);
            try {
                String resultedFile = this.removeFilterExtensions(fileSelected);
                this.writeImage(dialog, resultedFile, resultImage);
            }
            finally {
                resultImage.dispose();
            }
        }
        viewer.getControl().dispose();
        return null;
    }

    private String removeFilterExtensions(String fileName) {
        String resultedFile = fileName;
        if (fileName.toLowerCase().endsWith(".png") || fileName.toLowerCase().endsWith(".jpg") || fileName.toLowerCase().endsWith(".bmp")) {
            resultedFile = fileName.substring(0, fileName.length() - 4);
        } else if (fileName.toLowerCase().endsWith("png") || fileName.toLowerCase().endsWith("jpg") || fileName.toLowerCase().endsWith("bmp")) {
            resultedFile = fileName.substring(0, fileName.length() - 3);
        }
        return resultedFile;
    }

    public void writeImage(FileDialog dialog, String fileSelected, Image resultImage) {
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{resultImage.getImageData()};
        switch (dialog.getFilterIndex()) {
            case 0: {
                loader.save(fileSelected + ".png", 5);
                break;
            }
            case 1: {
                loader.save(fileSelected + ".jpg", 4);
                break;
            }
            case 2: {
                loader.save(fileSelected + ".bmp", 0);
                break;
            }
            default: {
                loader.save(fileSelected + ".png", 5);
            }
        }
    }
}

