/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.css;

import org.eclipse.draw2d.IFigure;
import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.gef.handles.MoveHandle;
import org.eclipse.swt.graphics.Color;
import org.mule.tooling.messageflow.css.IFigureElement;
import org.mule.tooling.messageflow.editpart.MuleSelectionBorder;
import org.mule.tooling.messageflow.editpart.RouteFigure;
import org.mule.tooling.messageflow.figure.ConnectorFigure;
import org.mule.tooling.messageflow.figure.ContainerFigure;
import org.mule.tooling.messageflow.figure.SplitterFigure;
import org.mule.tooling.messageflow.figure.SplitterPatternFigure;
import org.mule.tooling.messageflow.figure.TextFlowLabel;
import org.mule.tooling.model.messageflow.decorator.Connector;
import org.mule.tooling.model.messageflow.decorator.ConnectorType;
import org.mule.tooling.ui.widgets.util.ThemeUtils;
import org.w3c.dom.css.CSSValue;

public class ContainerCssHandler
implements ICSSPropertyHandler {
    private static final String SELECTION_BACKGROUND_ALPHA = "selection-background-alpha";
    private static final String SELECTION_BORDER_ARC_HEIGHT = "selection-border-arc-height";
    private static final String SELECTION_BORDER_ARC_WIDTH = "selection-border-arc-width";
    private static final String SELECTION_BORDER_WIDTH = "selection-border-width";
    private static final String SELECTION_BACKGROUND_COLOR = "selection-background-color";
    private static final String TITLE_COLOR = "title-color";
    private static final String TITLE_FONT_COLOR = "title-font-color";
    private static final String CONTAINER_BORDER = "container-border-color";
    private static final String DEFAULT_LANE_COLOR = "default-lane-color";
    private static final String SPLITTER_PATTERN_BORDER = "splitter-pattern-border-color";
    private static final String SPLITTER_PATTERN_BACKGROUND = "splitter-pattern-background-color";
    private static final String SPLITTER_BORDER = "splitter-border-color";
    private static final String CONNECTOR_FIGURE_COLOR = "connector-color";
    private static final String CONNECTOR_FIGURE_RESPONSE_COLOR = "connector-response-color";
    private static final String SELECTION_BORDER = "selection-border-color";
    private static final String CONTAINER_TOP_BORDER = "container-top-border-color";

    public boolean applyCSSProperty(Object element, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        if (element instanceof IFigureElement) {
            IFigure nativeWidget = ((IFigureElement)((Object)element)).getNativeWidget();
            if (nativeWidget instanceof TextFlowLabel) {
                return this.styleTextFlowLabel(nativeWidget, property, value, engine);
            }
            if (nativeWidget instanceof ContainerFigure) {
                return this.styleContainerFigure(nativeWidget, property, value, engine);
            }
            if (nativeWidget instanceof SplitterPatternFigure) {
                return this.styleSplitterPatternFigure(nativeWidget, property, value, engine);
            }
            if (nativeWidget instanceof SplitterFigure) {
                return this.styleSplitterFigure(nativeWidget, property, value, engine);
            }
            if (nativeWidget instanceof ConnectorFigure) {
                return this.styleConnectorFigure(nativeWidget, property, value, engine);
            }
            if (nativeWidget instanceof RouteFigure) {
                return this.styleRouteFigure(nativeWidget, property, value, engine);
            }
            if (nativeWidget instanceof MoveHandle) {
                return this.styleMoveHandle(nativeWidget, property, value, engine);
            }
        }
        return false;
    }

    private boolean styleMoveHandle(IFigure nativeWidget, String property, CSSValue value, CSSEngine engine) throws Exception {
        MoveHandle moveHandle = (MoveHandle)nativeWidget;
        MuleSelectionBorder selectionBorder = (MuleSelectionBorder)moveHandle.getBorder();
        if (SELECTION_BORDER.equalsIgnoreCase(property) && value.getCssValueType() == 1) {
            Color newColor = ThemeUtils.cssValueToColor((CSSValue)value, (CSSEngine)engine);
            selectionBorder.setSelectionColor(newColor);
            return true;
        }
        if (SELECTION_BACKGROUND_COLOR.equalsIgnoreCase(property) && value.getCssValueType() == 1) {
            Color newColor = ThemeUtils.cssValueToColor((CSSValue)value, (CSSEngine)engine);
            selectionBorder.setBackgroundColor(newColor);
            return true;
        }
        if (SELECTION_BORDER_WIDTH.equalsIgnoreCase(property) && value.getCssValueType() == 1) {
            int borderWidth = Integer.parseInt(value.getCssText());
            selectionBorder.setBorderWidth(borderWidth);
            return true;
        }
        if (SELECTION_BORDER_ARC_WIDTH.equalsIgnoreCase(property) && value.getCssValueType() == 1) {
            int arcWidth = Integer.parseInt(value.getCssText());
            selectionBorder.setArcWidth(arcWidth);
            return true;
        }
        if (SELECTION_BORDER_ARC_HEIGHT.equalsIgnoreCase(property) && value.getCssValueType() == 1) {
            int arcWidth = Integer.parseInt(value.getCssText());
            selectionBorder.setArcHeight(arcWidth);
            return true;
        }
        if (SELECTION_BACKGROUND_ALPHA.equalsIgnoreCase(property) && value.getCssValueType() == 1) {
            int alpha = Integer.parseInt(value.getCssText());
            selectionBorder.setAlpha(alpha);
            return true;
        }
        return false;
    }

    private boolean styleRouteFigure(IFigure nativeWidget, String property, CSSValue value, CSSEngine engine) throws Exception {
        RouteFigure containerFigure = (RouteFigure)nativeWidget;
        if (DEFAULT_LANE_COLOR.equalsIgnoreCase(property) && value.getCssValueType() == 1) {
            Color newColor = ThemeUtils.cssValueToColor((CSSValue)value, (CSSEngine)engine);
            if (containerFigure.getLineBorder() != null) {
                containerFigure.getLineBorder().setBorderColor(newColor);
            }
        }
        return false;
    }

    private boolean styleConnectorFigure(IFigure nativeWidget, String property, CSSValue value, CSSEngine engine) throws Exception {
        ConnectorFigure connectorFigure = (ConnectorFigure)nativeWidget;
        Connector modelConnector = connectorFigure.getConnector();
        if (CONNECTOR_FIGURE_COLOR.equalsIgnoreCase(property) && value.getCssValueType() == 1 && modelConnector.getType() == ConnectorType.REQUEST_FLOW) {
            Color newColor = ThemeUtils.cssValueToColor((CSSValue)value, (CSSEngine)engine);
            connectorFigure.setForegroundColor(newColor);
            return true;
        }
        if (CONNECTOR_FIGURE_RESPONSE_COLOR.equalsIgnoreCase(property) && value.getCssValueType() == 1 && modelConnector.getType() != ConnectorType.REQUEST_FLOW) {
            Color newColor = ThemeUtils.cssValueToColor((CSSValue)value, (CSSEngine)engine);
            connectorFigure.setForegroundColor(newColor);
            return true;
        }
        return false;
    }

    private boolean styleSplitterFigure(IFigure nativeWidget, String property, CSSValue value, CSSEngine engine) throws Exception {
        SplitterFigure splitterFigure = (SplitterFigure)nativeWidget;
        if (SPLITTER_BORDER.equalsIgnoreCase(property) && value.getCssValueType() == 1) {
            Color newColor = ThemeUtils.cssValueToColor((CSSValue)value, (CSSEngine)engine);
            splitterFigure.getLineBorder().setColor(newColor);
            return true;
        }
        return false;
    }

    private boolean styleSplitterPatternFigure(IFigure widget, String property, CSSValue value, CSSEngine engine) throws Exception {
        SplitterPatternFigure splitterPatternFigure = (SplitterPatternFigure)widget;
        if (SPLITTER_PATTERN_BORDER.equalsIgnoreCase(property) && value.getCssValueType() == 1) {
            Color newColor = ThemeUtils.cssValueToColor((CSSValue)value, (CSSEngine)engine);
            splitterPatternFigure.getSplitterBorder().setColor(newColor);
            return true;
        }
        if (SPLITTER_PATTERN_BACKGROUND.equalsIgnoreCase(property) && value.getCssValueType() == 1) {
            Color newColor = ThemeUtils.cssValueToColor((CSSValue)value, (CSSEngine)engine);
            splitterPatternFigure.setBackgroundColor(newColor);
            return true;
        }
        return false;
    }

    private boolean styleTextFlowLabel(IFigure nativeWidget, String property, CSSValue value, CSSEngine engine) throws Exception {
        TextFlowLabel textFlowLabelFigure = (TextFlowLabel)nativeWidget;
        if (TITLE_FONT_COLOR.equalsIgnoreCase(property) && value.getCssValueType() == 1) {
            Color newColor = ThemeUtils.cssValueToColor((CSSValue)value, (CSSEngine)engine);
            textFlowLabelFigure.getTextFlow().setForegroundColor(newColor);
            return true;
        }
        return false;
    }

    private boolean styleContainerFigure(IFigure element, String property, CSSValue value, CSSEngine engine) throws Exception {
        ContainerFigure containerFigure = (ContainerFigure)element;
        if (TITLE_FONT_COLOR.equalsIgnoreCase(property) && value.getCssValueType() == 1) {
            Color newColor = ThemeUtils.cssValueToColor((CSSValue)value, (CSSEngine)engine);
            containerFigure.getTitleLabel().setForegroundColor(newColor);
            return true;
        }
        if (CONTAINER_BORDER.equalsIgnoreCase(property) && value.getCssValueType() == 1) {
            Color newColor = ThemeUtils.cssValueToColor((CSSValue)value, (CSSEngine)engine);
            containerFigure.getLineBorder().setColor(newColor);
            containerFigure.setStyleableBorderColor(newColor);
            return true;
        }
        if (TITLE_COLOR.equalsIgnoreCase(property) && value.getCssValueType() == 1) {
            Color newColor = ThemeUtils.cssValueToColor((CSSValue)value, (CSSEngine)engine);
            containerFigure.getTitleFigure().setBackgroundColor(newColor);
            return true;
        }
        if (CONTAINER_TOP_BORDER.equalsIgnoreCase(property) && value.getCssValueType() == 1) {
            Color newColor = ThemeUtils.cssValueToColor((CSSValue)value, (CSSEngine)engine);
            containerFigure.getLineBorder().setTopBorderColor(newColor);
            return true;
        }
        return false;
    }

    public String retrieveCSSProperty(Object element, String property, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }
}

