/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.command;

import java.util.List;
import org.eclipse.gef.commands.Command;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.event.MessageFlowEntityEditedEvent;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.events.ExchangePatternChangedEvent;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.IPropertyCollectionReadCapability;
import org.mule.tooling.model.messageflow.IReadOnlyProperty;
import org.mule.tooling.model.messageflow.IReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.decorator.EndpointDecorator;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;
import org.mule.tooling.model.messageflow.decorator.MuleConfigurationDecorator;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.messageflow.util.PropertiesUtils;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.IEvent;

public class UpdatePropertiesCommand<T extends IMessageFlowNode>
extends Command {
    private EntityDecorator<T> decorator;
    private IReadOnlyPropertyCollection before;
    private PropertyCollection after;
    private MuleConfigurationDecorator configDecorator;
    private IMuleProject muleProject;

    public UpdatePropertiesCommand(IMuleProject muleProject, MuleConfigurationDecorator c, EntityDecorator<T> decorator, IReadOnlyPropertyCollection before, PropertyCollection after) {
        this.muleProject = muleProject;
        this.decorator = decorator;
        this.before = before;
        this.saveProperty(before, after, "index");
        this.saveProperty(before, after, "wrapIn");
        this.saveProperty(before, after, "wrappedIn");
        this.after = after;
        this.configDecorator = c;
    }

    private void saveProperty(IReadOnlyPropertyCollection before, PropertyCollection after, String propertyName) {
        IReadOnlyProperty prop;
        IReadOnlyProperty iReadOnlyProperty = prop = before == null ? null : PropertiesUtils.findPropertyReadOnlyByName((List)before.getProperties(), (String)("auxiliary;" + propertyName));
        if (prop != null) {
            after.getProperties().add(PropertiesUtils.toWritableProperty((IReadOnlyProperty)prop));
        }
    }

    private void setProperties(IMessageFlowNode node, PropertyCollection newProperties, IReadOnlyPropertyCollection previousProperties) {
        node.setProperties(newProperties);
        MuleCorePlugin.getEventBus().fireEvent((IEvent)new MessageFlowEntityEditedEvent(this.muleProject, (MessageFlowEntity)node, previousProperties));
    }

    public void execute() {
        EventBus eventBus = MuleCorePlugin.getEventBus();
        EntityDecorator<T> decorator = this.getDecorator();
        PropertyCollection newProperties = this.getAfter();
        IMessageFlowNode entity = (IMessageFlowNode)decorator.getEntity();
        this.setProperties(entity, newProperties, this.getBefore());
        decorator.fireEvent("properties");
        if (this.configDecorator != null) {
            if (!(entity instanceof GlobalElement)) {
                String displayNameAttribute = entity.getDefinition().getDisplayNameAtribute();
                String newName = newProperties.getProperty(displayNameAttribute) != null ? newProperties.getProperty(displayNameAttribute).getValue() : entity.getName();
                entity.setName(newName);
            }
            List globalEntries = ((MuleConfiguration)this.configDecorator.getEntity()).getGlobalEntries();
            for (IMessageFlowEntity z : globalEntries) {
                if (!z.getEntityId().equals(((IMessageFlowNode)decorator.getEntity()).getEntityId())) continue;
                MessageFlowNode nn = (MessageFlowNode)z;
                this.setProperties((IMessageFlowNode)nn, newProperties, this.getBefore());
            }
            this.configDecorator.fireEvent("globals");
        }
        if (decorator instanceof EndpointDecorator && this.didExchangePatternChange()) {
            EndpointDecorator endpointDecorator = (EndpointDecorator)decorator;
            MessageFlowEditor editor = MessageFlowUtils.getFlowEditorFromActivePage();
            EntityEditPart<?> editPart = editor.findEditPart((IMessageFlowEntity)((MessageFlowEntity)entity));
            if (editPart != null) {
                ExchangePatternChangedEvent event = new ExchangePatternChangedEvent(editPart);
                eventBus.fireEvent((IEvent)event);
            }
            endpointDecorator.fireExchangePatternChanged();
        }
    }

    public void undo() {
        PropertyCollection beforePropertyCollection = PropertiesUtils.toWritablePropertyCollection((IPropertyCollectionReadCapability)this.getBefore());
        this.setProperties((IMessageFlowNode)this.getDecorator().getEntity(), beforePropertyCollection, ((IMessageFlowNode)this.decorator.getEntity()).getProperties());
        if (this.configDecorator != null) {
            PropertyCollectionMap propertyCollectionMap = new PropertyCollectionMap(beforePropertyCollection);
            String property = propertyCollectionMap.getProperty("name", ((IMessageFlowNode)this.decorator.getEntity()).getName());
            ((IMessageFlowNode)this.decorator.getEntity()).setName(property);
            List globalEntries = ((MuleConfiguration)this.configDecorator.getEntity()).getGlobalEntries();
            for (IMessageFlowEntity z : globalEntries) {
                if (!z.getEntityId().equals(((IMessageFlowNode)this.getDecorator().getEntity()).getEntityId())) continue;
                MessageFlowNode nn = (MessageFlowNode)z;
                this.setProperties((IMessageFlowNode)nn, beforePropertyCollection, ((IMessageFlowNode)this.decorator.getEntity()).getProperties());
            }
            this.configDecorator.fireEvent("globals");
        }
        if (this.decorator instanceof EndpointDecorator && this.didExchangePatternChange()) {
            ((EndpointDecorator)this.decorator).fireExchangePatternChanged();
        }
    }

    protected boolean didExchangePatternChange() {
        String aexchange;
        PropertyCollectionMap bprops = new PropertyCollectionMap(this.getBefore());
        PropertyCollectionMap aprops = new PropertyCollectionMap(this.getAfter());
        String bexchange = bprops.getProperty("exchange-pattern", "");
        return !bexchange.equals(aexchange = aprops.getProperty("exchange-pattern", ""));
    }

    public EntityDecorator<T> getDecorator() {
        return this.decorator;
    }

    public void setDecorator(EntityDecorator<T> decorator) {
        this.decorator = decorator;
    }

    public IReadOnlyPropertyCollection getBefore() {
        return this.before;
    }

    public PropertyCollection getAfter() {
        return this.after;
    }

    public void setAfter(PropertyCollection after) {
        this.after = after;
    }
}

