/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.commands.CompoundCommand;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.module.IMuleModuleManager;
import org.mule.tooling.messageflow.command.UpdatePropertiesCommand;
import org.mule.tooling.messageflow.editor.GlobalElementEditor;
import org.mule.tooling.messageflow.editor.MultiPageMessageFlowEditor;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.IReadOnlyProperty;
import org.mule.tooling.model.messageflow.IReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.MuleConfigurationTraverser;
import org.mule.tooling.model.messageflow.Property;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.decorator.MessageFlowNodeDecorator;
import org.mule.tooling.model.messageflow.decorator.MuleConfigurationDecorator;
import org.mule.tooling.model.messageflow.util.PropertiesUtils;
import org.mule.tooling.model.module.ICanEvalGlobalRefs;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;

public class UpdateFlowsCommand
extends CompoundCommand {
    private GlobalElementEditor.PropertyTransformer transformer;
    private IMuleProject muleProject;

    public UpdateFlowsCommand(IMuleProject muleProject, GlobalElementEditor.PropertyTransformer transformer, MuleConfigurationDecorator configDecorator) {
        this.muleProject = muleProject;
        this.transformer = transformer;
        this.updateFlows();
    }

    private void updateFlows() {
        MultiPageMessageFlowEditor activeEditor = MultiPageMessageFlowEditor.getActive();
        String version = new AttributeContext().getVersion();
        IMuleModuleManager moduleManager = this.muleProject.getModuleManager();
        final ArrayList configsToMarkAsDirty = new ArrayList();
        final List definitions = moduleManager.getDefinitions(version);
        for (final MuleConfiguration config : activeEditor.getMuleProject().getConfigurationsCache().getConfigurations()) {
            MuleConfigurationTraverser visitor = new MuleConfigurationTraverser(config){

                protected boolean visitMessageFlowNode(IMessageFlowNode node) {
                    String type = node.getType();
                    if (type == null) {
                        return super.visitMessageFlowNode(node);
                    }
                    for (NodeDefinition definition : definitions) {
                        String id = definition.getId();
                        if (!type.equals(id)) continue;
                        ICanEvalGlobalRefs service = (ICanEvalGlobalRefs)definition.findServiceImplements(ICanEvalGlobalRefs.class);
                        if (service == null) {
                            return super.visitMessageFlowNode(node);
                        }
                        ArrayList<String> globalRefs = new ArrayList<String>(service.evalGlobalRefs().keySet());
                        UpdateFlowsCommand.this.addCustomRefs(globalRefs);
                        MessageFlowNodeDecorator decorator = new MessageFlowNodeDecorator(node);
                        PropertyCollection newProps = new PropertyCollection();
                        UpdateFlowsCommand.this.cloneOldProperties(newProps, node.getProperties());
                        UpdateFlowsCommand.this.setPropertyValue(node, globalRefs, newProps);
                        newProps.setElement(node.getElement());
                        UpdatePropertiesCommand command = new UpdatePropertiesCommand(UpdateFlowsCommand.this.muleProject, new MuleConfigurationDecorator(config), decorator, node.getProperties(), newProps);
                        UpdateFlowsCommand.this.add(command);
                        configsToMarkAsDirty.add(config);
                        return super.visitMessageFlowNode(node);
                    }
                    return super.visitMessageFlowNode(node);
                }
            };
            visitor.traverse();
        }
        for (MultiPageMessageFlowEditor multiPageMessageFlowEditor : MessageFlowUtils.getOpenMultipageMessageFlowEditors()) {
            if (!configsToMarkAsDirty.contains(multiPageMessageFlowEditor.getMuleConfiguration())) continue;
            multiPageMessageFlowEditor.markAsModified();
        }
    }

    public boolean canExecute() {
        return true;
    }

    private void addCustomRefs(List<String> globalRefs) {
        globalRefs.add("transformer-refs");
        globalRefs.add("responseTransformer-refs");
    }

    private void setPropertyValue(IMessageFlowNode node, List<String> globalRefs, PropertyCollection newProps) {
        for (String globalRef : globalRefs) {
            IReadOnlyProperty globalRefProp = PropertiesUtils.findPropertyByName((IMessageFlowNode)node, (String)globalRef);
            if (globalRefProp == null) continue;
            newProps.getProperty(globalRef).setValue(this.transformer.transform(globalRefProp.getValue()));
        }
    }

    private void cloneOldProperties(PropertyCollection newProps, IReadOnlyPropertyCollection oldProps) {
        for (IReadOnlyProperty prop : oldProps.getProperties()) {
            newProps.addProperty(this.createProperty(prop.getName(), prop.getValue()));
        }
        for (IReadOnlyPropertyCollection propCol : oldProps.getPropertyCollections()) {
            PropertyCollection propColClone = new PropertyCollection();
            this.cloneOldProperties(propColClone, propCol);
            propColClone.setName(propCol.getName());
            propColClone.setElement(propCol.getElement());
            newProps.addPropertyCollection(propColClone);
        }
    }

    public boolean canUndo() {
        return true;
    }

    public void undo() {
        super.undo();
    }

    private Property createProperty(String name, String value) {
        Property property = new Property();
        property.setName(name);
        property.setValue(value);
        return property;
    }
}

