/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.command;

import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.mule.tooling.messageflow.command.TransactionalCommand;

public class TransactionalCompoundCommand
extends CompoundCommand
implements TransactionalCommand {
    private boolean interruptedExecution;
    private boolean firstCommand;
    private boolean lastCommand;

    public TransactionalCompoundCommand() {
    }

    public TransactionalCompoundCommand(String label) {
        super(label);
    }

    public void execute() {
        if (!this.isInterruptedExecution()) {
            int i = 0;
            while (i < this.getCommands().size()) {
                Command cmd = (Command)this.getCommands().get(i);
                cmd.execute();
                if (((TransactionalCommand)cmd).isInterruptedExecution()) {
                    this.setInterruptedExecution(true);
                    this.undoPreviousCommands(i);
                    return;
                }
                ++i;
            }
        }
    }

    public void undoPreviousCommands(int lastPosition) {
        int i = lastPosition - 1;
        while (i >= 0) {
            Command command = (Command)this.getCommands().get(i);
            if (command.canUndo()) {
                command.undo();
                ((TransactionalCommand)command).setInterruptedExecution(true);
            }
            --i;
        }
    }

    public boolean canUndo() {
        return true;
    }

    @Override
    public synchronized boolean isInterruptedExecution() {
        return this.interruptedExecution;
    }

    @Override
    public synchronized void setInterruptedExecution(boolean interruptedExecution) {
        this.interruptedExecution = interruptedExecution;
    }

    public void undo() {
        if (this.isInterruptedExecution()) {
            return;
        }
        super.undo();
    }

    @Override
    public void setFirstCommand(boolean value) {
        this.firstCommand = value;
    }

    @Override
    public void setLastCommand(boolean value) {
        this.lastCommand = value;
    }

    @Override
    public boolean isFirstCommand() {
        return this.firstCommand;
    }

    @Override
    public boolean isLastCommand() {
        return this.lastCommand;
    }
}

