/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.command;

import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.dom.IDocumentWrapper;
import org.mule.tooling.core.generator.IFlowTransformerContext;
import org.mule.tooling.core.generator.NewFlowTransformerContext;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.command.IMessageFlowEntityFactory;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.EndpointDirection;
import org.mule.tooling.model.messageflow.EndpointNode;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.IPropertyCollectionReadCapability;
import org.mule.tooling.model.messageflow.MessageFlowFactory;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.util.PropertiesUtils;
import org.mule.tooling.model.module.EndpointDefinition;
import org.mule.tooling.model.module.NestedDefinition;
import org.mule.tooling.model.module.NodeDefinition;

public class SchedulerEntityFactory
implements IMessageFlowEntityFactory {
    private static final String FIXED_FREQUENCY_ID = "http://www.mulesoft.org/schema/mule/core/fixed-frequency";
    private static final String SCHEDULING_STRATEGY_ID = "http://www.mulesoft.org/schema/mule/core/scheduling-strategy";

    @Override
    public IMessageFlowNode create(MuleConfiguration muleConfiguration, IMessageFlowEntity container, NodeDefinition target, IMessageFlowEntity beforeMessageFlowEntity, IMessageFlowEntity afterMessageFlowEntity) {
        IFlowTransformerContext context = NewFlowTransformerContext.create((IMuleProject)MuleCorePlugin.getDesignContext().getMuleProject(), (MuleConfiguration)muleConfiguration);
        EndpointNode endpointNode = MessageFlowFactory.createEndpointNode((IFlowTransformerContext)context, (EndpointDefinition)((EndpointDefinition)target), (EndpointDirection)EndpointDirection.INBOUND);
        PropertyCollection properties = PropertiesUtils.toWritablePropertyCollection((IPropertyCollectionReadCapability)endpointNode.getProperties());
        IDocumentWrapper document = endpointNode.getElement().getDocument();
        PropertyCollection schedulerStrategyProperties = new PropertyCollection();
        schedulerStrategyProperties.setName(SchedulerEntityFactory.createId(SCHEDULING_STRATEGY_ID));
        NestedDefinition schedulerStrategyDefinition = MuleCorePlugin.getModuleManager().getNestedDefinition(SCHEDULING_STRATEGY_ID);
        schedulerStrategyProperties.setElement(MessageFlowUtils.createElement(document, schedulerStrategyDefinition));
        properties.setProperty("auxiliary;MODE;schedulingStrategy", "CHILD");
        PropertyCollection fixedFrequencyProperties = new PropertyCollection();
        fixedFrequencyProperties.setName(SchedulerEntityFactory.createId(FIXED_FREQUENCY_ID));
        NestedDefinition fixedFrequencyDefinition = MuleCorePlugin.getModuleManager().getNestedDefinition(FIXED_FREQUENCY_ID);
        fixedFrequencyProperties.setElement(MessageFlowUtils.createElement(document, fixedFrequencyDefinition));
        schedulerStrategyProperties.addPropertyCollection(fixedFrequencyProperties);
        properties.addPropertyCollection(schedulerStrategyProperties);
        endpointNode.setProperties(properties);
        return endpointNode;
    }

    public static String createId(String id) {
        return PropertiesUtils.createCollectionIdWithSuffix((String)id, (long)Long.MAX_VALUE);
    }
}

