/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.command;

import org.eclipse.gef.EditPartViewer;
import org.mule.tooling.messageflow.command.ReparentEntityCommand;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.util.MessageFlowEntityRef;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.Compartment;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.Route;
import org.mule.tooling.model.messageflow.decorator.CompartmentDecorator;
import org.mule.tooling.model.messageflow.decorator.CompartmentLaneDecorator;
import org.mule.tooling.model.messageflow.decorator.ContainerOfMovableEntities;

public class ReparentEntityToSplitterCommand
extends ReparentEntityCommand {
    public ReparentEntityToSplitterCommand(CompartmentDecorator compartment, IMessageFlowEntity messageFlowEntity, MuleConfiguration muleConfiguration, EntityEditPart<? extends IMessageFlowEntity> entityEditPart) {
        super(muleConfiguration, entityEditPart);
        this.setCompartment(compartment);
        this.setMessageFlowEntity(messageFlowEntity);
        this.setRemoveLane(true);
        MessageFlowEntityRef oldMulePath = MessageFlowUtils.findMulePathForEntityInOpenEditors(messageFlowEntity);
        if (oldMulePath != null) {
            this.setOldPath(oldMulePath.getMulePath());
        }
    }

    @Override
    protected void doExecute() {
        if (this.isInterruptedExecution()) {
            return;
        }
        this.setOldIndex(this.getOldContainer().findEntityIndex(this.getMessageFlowEntity()));
        CompartmentLane emptyLane = this.getEmptyLane((CompartmentDecorator)this.getCompartment());
        EditPartViewer editPartViewer = this.getRootEditPart().getViewer();
        if (emptyLane != null) {
            EntityEditPart<?> emptyLanePart = MessageFlowEditor.findEditPartInRegistry(editPartViewer, (IMessageFlowEntity)emptyLane);
            this.setContainer((ContainerOfMovableEntities)((CompartmentLaneDecorator)emptyLanePart.getEntityDecorator()));
        } else {
            this.addLaneToCompartment();
        }
        this.setRemoveLane(false);
        this.setAfterMessageFlowEntity(null);
        int targetIndex = this.getIndex();
        if (this.getAfterMessageFlowEntity() == null) {
            ++targetIndex;
        }
        this.getOldContainer().moveMessageFlowEntityTo(this.getMessageFlowEntity(), this.getContainer(), targetIndex, this.isLastCommand());
        this.removeLane(this.getOldCompartment(), this.getOldContainer());
    }

    private CompartmentLane getEmptyLane(CompartmentDecorator compartmentDecorator) {
        Compartment compartment = (Compartment)compartmentDecorator.getEntity();
        CompartmentLane emptyLane = null;
        for (CompartmentLane lane : compartment.getLanes()) {
            if (!lane.getCompartmentLaneEntries().isEmpty() || !this.isGrowableRoute(lane)) continue;
            emptyLane = lane;
        }
        return emptyLane;
    }

    private boolean isGrowableRoute(CompartmentLane lane) {
        if (lane instanceof Route) {
            Route route = (Route)lane;
            return route.getDefinition().getMaxOccurrence() > 1;
        }
        return true;
    }

    @Override
    public void undo() {
        if (this.isInterruptedExecution()) {
            return;
        }
        super.undo();
        this.comeBackToInbound();
        this.addLaneToOldCompartment();
        this.getContainer().moveMessageFlowEntityTo(this.getMessageFlowEntity(), this.getOldContainer(), this.getOldIndex(), this.isFirstCommand());
        if (this.getOldContainer() instanceof CompartmentLaneDecorator && this.isSplitter()) {
            EntityEditPart<?> containerLanePart = MessageFlowEditor.findEditPartInRegistry(this.getRootEditPart().getViewer(), ((CompartmentLaneDecorator)this.getOldContainer()).getEntity());
            CompartmentLaneDecorator compartmentLaneDecorator = (CompartmentLaneDecorator)containerLanePart.getEntityDecorator();
            compartmentLaneDecorator.fireEvent("entities");
        }
        this.removeLane(this.getCompartment(), this.getContainer());
    }
}

