/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.command;

import org.mule.tooling.messageflow.command.MessageFlowEntityAdapterManager;
import org.mule.tooling.messageflow.command.ReparentEntityCommand;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.decorator.ContainerOfMovableEntities;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;
import org.mule.tooling.model.module.NodeDefinition;

public class ReparentEntityToANewContainerCommand
extends ReparentEntityCommand {
    private IMessageFlowEntity addedEntity;

    public ReparentEntityToANewContainerCommand(ContainerOfMovableEntities model, IMessageFlowEntity messageFlowEntity, MuleConfiguration muleConfiguration) {
        super(model, messageFlowEntity, muleConfiguration, null);
    }

    @Override
    protected void doExecute() {
        if (this.isInterruptedExecution()) {
            return;
        }
        this.setOldIndex(this.getOldContainer().findEntityIndex(this.getMessageFlowEntity()));
        int targetIndex = this.getIndex();
        if (this.getAfterMessageFlowEntity() == null) {
            ++targetIndex;
        }
        this.getOldContainer().removeEntity(this.getMessageFlowEntity(), true);
        EntityDecorator targetDecorator = (EntityDecorator)this.getContainer();
        this.addedEntity = this.getMessageFlowEntity();
        NodeDefinition targetContainerDefinition = MessageFlowUtils.getDefinition(targetDecorator.getEntity());
        if (MessageFlowEntityAdapterManager.get().hasAdapter(targetContainerDefinition, this.getMessageFlowEntity())) {
            this.addedEntity = MessageFlowEntityAdapterManager.get().getAdapter(targetContainerDefinition, this.getMessageFlowEntity()).adapt(this.getMuleConfiguration(), this.addedEntity);
        }
        this.getContainer().addEntity(targetIndex, this.addedEntity, true);
        ((EntityDecorator)this.getOldContainer()).fireEvent("entities");
        this.removeLane(this.getOldCompartment(), this.getOldContainer());
    }

    @Override
    public void undo() {
        super.undo();
        if (this.isInterruptedExecution()) {
            return;
        }
        this.addLaneToOldCompartment();
        this.getContainer().removeEntity(this.addedEntity, true);
        this.getOldContainer().addEntity(this.getOldIndex(), this.getMessageFlowEntity());
        ((EntityDecorator)this.getOldContainer()).fireEvent("entities");
    }
}

