/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.command;

import java.util.Optional;
import org.eclipse.gef.EditPart;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.generator.IFlowTransformerContext;
import org.mule.tooling.core.generator.NewFlowTransformerContext;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.command.AddCompartmentLaneCommand;
import org.mule.tooling.messageflow.command.MoveEntityCommand;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.editpart.CompartmentEditPart;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowFactory;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.Route;
import org.mule.tooling.model.messageflow.decorator.CompartmentDecorator;
import org.mule.tooling.model.messageflow.decorator.CompartmentLaneDecorator;
import org.mule.tooling.model.messageflow.decorator.ContainerOfMovableEntities;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;
import org.mule.tooling.model.module.RouteDefinition;

public abstract class ReparentEntityCommand
extends MoveEntityCommand {
    private ContainerOfMovableEntities oldContainer;
    private Object oldCompartment;
    private boolean removeLane;
    private boolean isSplitter;
    private EditPart rootEditPart;
    private Object compartment;
    private MuleConfiguration muleConfiguration;
    private EntityEditPart<? extends MessageFlowEntity> entityEditPart;

    public ReparentEntityCommand(MuleConfiguration muleConfiguration, EntityEditPart<? extends IMessageFlowEntity> entityEditPart) {
        this(null, null, muleConfiguration, entityEditPart);
    }

    public ReparentEntityCommand(ContainerOfMovableEntities containerOfMovableEntities, IMessageFlowEntity messageFlowEntity, MuleConfiguration muleConfiguration, EntityEditPart<? extends MessageFlowEntity> entityEditPart) {
        super(containerOfMovableEntities, messageFlowEntity);
        this.muleConfiguration = muleConfiguration;
        this.entityEditPart = entityEditPart;
    }

    protected MuleConfiguration getMuleConfiguration() {
        return this.muleConfiguration;
    }

    protected void addLaneToOldCompartment() {
        if (this.isRemoveLane()) {
            this.resetOldCompartment();
            CompartmentLane lane = (CompartmentLane)((CompartmentLaneDecorator)this.getOldContainer()).getEntity();
            CompartmentDecorator oldCompartmentDecorator = (CompartmentDecorator)this.oldCompartment;
            EntityEditPart<?> compartmentPart = MessageFlowEditor.findEditPartInRegistry(this.getRootEditPart().getViewer(), oldCompartmentDecorator.getEntity());
            IMuleProject project = MuleCorePlugin.getDesignContext().getMuleProject();
            Optional<IElementWrapper> laneXml = MessageFlowUtils.generateSplitterLaneXml(project, compartmentPart, lane);
            laneXml.ifPresent(arg_0 -> ((CompartmentLane)lane).setElement(arg_0));
            AddCompartmentLaneCommand addLane = new AddCompartmentLaneCommand(oldCompartmentDecorator, (CompartmentLaneDecorator<CompartmentLane>)((CompartmentLaneDecorator)this.getOldContainer()));
            addLane.execute();
            EntityEditPart<?> lanePart = MessageFlowEditor.findEditPartInRegistry(this.getRootEditPart().getViewer(), (IMessageFlowEntity)lane);
            CompartmentLaneDecorator laneDecorator = (CompartmentLaneDecorator)lanePart.getEntityDecorator();
            this.setOldContainer((ContainerOfMovableEntities)laneDecorator);
            this.setRemoveLane(false);
        }
    }

    protected void addLaneToCompartment() {
        if (this.isRemoveLane()) {
            this.resetCompartment();
            CompartmentLane lane = this.addNewLane(this.getCompartment());
            EntityEditPart<?> lanePart = MessageFlowEditor.findEditPartInRegistry(this.getRootEditPart().getViewer(), (IMessageFlowEntity)lane);
            CompartmentLaneDecorator laneDecorator = (CompartmentLaneDecorator)lanePart.getEntityDecorator();
            this.setContainer((ContainerOfMovableEntities)laneDecorator);
        }
    }

    public void resetCompartment() {
        EntityEditPart<?> compartmentPart = MessageFlowEditor.findEditPartInRegistry(this.getRootEditPart().getViewer(), ((CompartmentDecorator)this.getCompartment()).getEntity());
        EntityDecorator<?> compartmentDecorator = compartmentPart.getEntityDecorator();
        this.setCompartment(compartmentDecorator);
    }

    public CompartmentLane addNewLane(Object compartment) {
        CompartmentDecorator compartmentDecorator = (CompartmentDecorator)compartment;
        IFlowTransformerContext context = NewFlowTransformerContext.create((IMuleProject)MuleCorePlugin.getDesignContext().getMuleProject(), (MuleConfiguration)this.muleConfiguration);
        context.getEntityStack().push(this.entityEditPart.getEntity());
        CompartmentLane lane = MessageFlowFactory.createCompartmentLane((IFlowTransformerContext)context);
        AddCompartmentLaneCommand addLane = new AddCompartmentLaneCommand(compartmentDecorator, lane);
        addLane.execute();
        return lane;
    }

    public void resetOldCompartment() {
        EntityEditPart<?> compartmentPart = MessageFlowEditor.findEditPartInRegistry(this.getRootEditPart().getViewer(), ((CompartmentDecorator)this.getOldCompartment()).getEntity());
        EntityDecorator<?> compartmentDecorator = compartmentPart.getEntityDecorator();
        this.setOldCompartment(compartmentDecorator);
    }

    protected void removeLane(Object compartment, ContainerOfMovableEntities container) {
        boolean laneIsEmpty;
        boolean bl = laneIsEmpty = compartment instanceof CompartmentDecorator && container instanceof CompartmentLaneDecorator && ((CompartmentLane)((CompartmentLaneDecorator)container).getEntity()).getCompartmentLaneEntries().size() == 0;
        if (laneIsEmpty) {
            CompartmentLaneDecorator laneDecorator = (CompartmentLaneDecorator)container;
            EntityEditPart<?> compartmentPart = MessageFlowEditor.findEditPartInRegistry(this.getRootEditPart().getViewer(), ((CompartmentDecorator)compartment).getEntity());
            CompartmentDecorator compartmentDecorator = (CompartmentDecorator)compartmentPart.getEntityDecorator();
            if (CompartmentEditPart.isFromRouter(compartmentPart)) {
                Route route = (Route)laneDecorator.getEntity();
                RouteDefinition routeDefinition = route.getDefinition();
                long routeCountForType = routeDefinition.count(compartmentDecorator.getLanes());
                if (routeCountForType > (long)routeDefinition.getMinOccurrence()) {
                    this.setRemoveLane(true);
                    compartmentDecorator.removeLane((CompartmentLane)laneDecorator.getEntity());
                }
            } else {
                this.setRemoveLane(true);
                compartmentDecorator.removeLane((CompartmentLane)laneDecorator.getEntity());
            }
        }
    }

    public void undo() {
    }

    public synchronized ContainerOfMovableEntities getOldContainer() {
        return this.oldContainer;
    }

    public synchronized void setOldContainer(ContainerOfMovableEntities oldContainer) {
        this.oldContainer = oldContainer;
    }

    public synchronized Object getOldCompartment() {
        return this.oldCompartment;
    }

    public synchronized void setOldCompartment(Object oldCompartment) {
        this.oldCompartment = oldCompartment;
    }

    public synchronized boolean isRemoveLane() {
        return this.removeLane;
    }

    public synchronized void setRemoveLane(boolean removeLane) {
        this.removeLane = removeLane;
    }

    public synchronized boolean isSplitter() {
        return this.isSplitter;
    }

    public synchronized void setSplitter(boolean isSplitter) {
        this.isSplitter = isSplitter;
    }

    public synchronized EditPart getRootEditPart() {
        return this.rootEditPart;
    }

    public synchronized void setRootEditPart(EditPart editPart) {
        this.rootEditPart = editPart;
    }

    public synchronized Object getCompartment() {
        return this.compartment;
    }

    public synchronized void setCompartment(Object compartment) {
        this.compartment = compartment;
    }

    public void resetContainer() {
        EntityEditPart<?> containerLanePart;
        if (this.getContainer() instanceof CompartmentLaneDecorator && (containerLanePart = MessageFlowEditor.findEditPartInRegistry(this.getRootEditPart().getViewer(), ((CompartmentLaneDecorator)this.getContainer()).getEntity())) != null) {
            CompartmentLaneDecorator compartmentLaneDecorator = (CompartmentLaneDecorator)containerLanePart.getEntityDecorator();
            this.setContainer((ContainerOfMovableEntities)compartmentLaneDecorator);
        }
    }

    public void resetOldContainer() {
        EntityEditPart<?> containerLanePart;
        if (this.getOldContainer() instanceof CompartmentLaneDecorator && (containerLanePart = MessageFlowEditor.findEditPartInRegistry(this.getRootEditPart().getViewer(), ((CompartmentLaneDecorator)this.getOldContainer()).getEntity())) != null) {
            CompartmentLaneDecorator compartmentLaneDecorator = (CompartmentLaneDecorator)containerLanePart.getEntityDecorator();
            this.setOldContainer((ContainerOfMovableEntities)compartmentLaneDecorator);
        }
    }

    public void redo() {
        this.addLaneToCompartment();
        this.setRemoveLane(false);
        this.resetContainer();
        this.resetOldContainer();
        this.execute();
    }

    @Override
    protected void doExecute() {
    }
}

