/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.command;

import java.util.List;
import org.eclipse.gef.commands.Command;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.cache.IMuleConfigurationsCache;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.IPropertyCollectionReadCapability;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.util.PropertiesUtils;
import org.mule.tooling.utils.Pair;

public class RenameFlowReferencesCommand
extends Command {
    private String oldName;
    private String newName;
    private IMessageFlowNode model;

    public RenameFlowReferencesCommand(IMessageFlowNode model, String oldName, String newName) {
        this.model = model;
        this.oldName = oldName;
        this.newName = newName;
    }

    public boolean canExecute() {
        return this.model instanceof IMessageFlowNode;
    }

    public void execute() {
        this.doRenameReferences(this.oldName, this.newName);
    }

    public void undo() {
        this.doRenameReferences(this.newName, this.oldName);
    }

    private void doRenameReferences(String currentName, String updatedName) {
        Pair flowWithSameName;
        IMuleConfigurationsCache muleConfigurationsCache = MuleCorePlugin.getDesignContext().getMuleProject().getConfigurationsCache();
        List flowReferencesByFlowName = muleConfigurationsCache.getFlowReferencesByFlowName(currentName);
        if (!(flowReferencesByFlowName.isEmpty() || (flowWithSameName = muleConfigurationsCache.searchMuleFlowByName(currentName)) != null && flowWithSameName.getRight() != this.model)) {
            for (IMessageFlowNode messageFlowNode : flowReferencesByFlowName) {
                this.updateReferenceForFlowRef(messageFlowNode, updatedName);
            }
        }
    }

    private void updateReferenceForFlowRef(IMessageFlowNode flowRef, String updatedName) {
        PropertyCollection properties = PropertiesUtils.toWritablePropertyCollection((IPropertyCollectionReadCapability)flowRef.getProperties());
        properties.setProperty("name", updatedName);
        flowRef.setProperties(properties);
    }
}

