/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.command;

import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.command.RenameEntityCommand;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.IPropertyCollectionReadCapability;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.util.PropertiesUtils;
import org.mule.tooling.utils.Pair;

public class RenameContainerRefNameCommand
extends RenameEntityCommand {
    private PropertyCollection oldProperties;
    private PropertyCollection newProperties;

    public RenameContainerRefNameCommand(IMessageFlowNode model, String newName) {
        super(model, newName);
    }

    public RenameContainerRefNameCommand(IMessageFlowNode model, String oldName, String newName, PropertyCollection oldProperties, PropertyCollection newProperties) {
        super(model, oldName, newName);
        this.oldProperties = oldProperties;
        this.newProperties = newProperties;
    }

    @Override
    public void execute() {
        IMuleProject muleProject;
        Pair muleFlowPair;
        IMessageFlowNode model = this.getModel();
        if (this.newProperties != null) {
            model.setProperties(this.newProperties);
        }
        if ((muleFlowPair = (muleProject = MuleCorePlugin.getDesignContext().getMuleProject()).getConfigurationsCache().searchMuleFlowByName(this.getNewName())) != null) {
            PropertyCollection properties = PropertiesUtils.toWritablePropertyCollection((IPropertyCollectionReadCapability)model.getProperties());
            properties.setProperty("name", this.getNewName());
            model.setProperties(properties);
        }
        model.setName(this.getNewName());
    }

    @Override
    public void undo() {
        this.getModel().setName(this.getOldName());
        this.getModel().setProperties(this.oldProperties);
    }
}

