/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.command;

import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;
import org.mule.tooling.client.metadata.ITypesManager;
import org.mule.tooling.client.metadata.enricher.MetadataEnricher;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.event.MessageFlowEntityDeletedEvent;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.command.LaneDeleteCommand;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.editpart.CompartmentEditPart;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.editpart.SplitterEditPart;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.metadata.cache.MetadataTypesManager;
import org.mule.tooling.metadata.custom.metadata.assistant.CustomMetadataAssistantService;
import org.mule.tooling.model.messageflow.CommentContainer;
import org.mule.tooling.model.messageflow.Compartment;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.ComponentId;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.Route;
import org.mule.tooling.model.messageflow.decorator.CompartmentLaneDecorator;
import org.mule.tooling.model.module.RouteDefinition;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.IEvent;

public class NodeDeleteCommand
extends Command {
    private final EditPartViewer viewer;
    private final IMessageFlowEntity node;
    private final Compartment parent;
    private final CompartmentLane lane;
    private final IMessageFlowEntity before;
    private final IMessageFlowEntity after;
    private boolean fireEvents;
    private EventBus eventBus;
    private Optional<MetadataEnricher> enricher = Optional.empty();
    private Optional<LaneDeleteCommand> laneDeleteCommand = Optional.empty();

    public NodeDeleteCommand(EditPartViewer viewer, MessageFlowEntity node, Compartment parent, CompartmentLane lane, EventBus eventBus, boolean fireEvents) {
        this.node = node;
        this.lane = lane;
        this.parent = parent;
        this.viewer = viewer;
        EntityEditPart<?> lanePart = MessageFlowEditor.findEditPartInRegistry(viewer, (IMessageFlowEntity)lane);
        CompartmentLaneDecorator laneDecorator = (CompartmentLaneDecorator)lanePart.getEntityDecorator();
        this.before = laneDecorator.getEntityBefore((IMessageFlowEntity)node);
        this.after = laneDecorator.getEntityAfter((IMessageFlowEntity)node);
        this.eventBus = eventBus;
        this.fireEvents = fireEvents;
    }

    public NodeDeleteCommand(EditPartViewer viewer, MessageFlowEntity node, Compartment parent, CompartmentLane lane, EventBus eventBus) {
        this(viewer, node, parent, lane, eventBus, true);
    }

    public void execute() {
        IMuleProject project = MuleCorePlugin.getDesignContext().getMuleProject();
        EntityEditPart<?> compartmentPart = MessageFlowEditor.findEditPartInRegistry(this.viewer, (IMessageFlowEntity)this.parent);
        if (compartmentPart == null) {
            return;
        }
        EntityEditPart<?> lanePart = MessageFlowEditor.findEditPartInRegistry(this.viewer, (IMessageFlowEntity)this.lane);
        if (lanePart == null) {
            return;
        }
        ComponentId componentId = ComponentId.UNDEFINED;
        if (this.node instanceof MessageFlowNode && !(this.node instanceof CommentContainer)) {
            MessageFlowNode messageFlowNode = (MessageFlowNode)this.node;
            boolean isFlowReference = messageFlowNode.getType().equals("http://www.mulesoft.org/schema/mule/core/flow-ref");
            componentId = ComponentId.from((IMessageFlowEntity)messageFlowNode);
            if (isFlowReference) {
                ((CustomMetadataAssistantService)project.getProjectComponent(CustomMetadataAssistantService.class)).deleteAutogeneratedMetadataByFlowRefDocId(componentId.toString());
            }
        }
        CompartmentLaneDecorator laneDecorator = (CompartmentLaneDecorator)lanePart.getEntityDecorator();
        IFile configFile = MessageFlowUtils.getFlowEditorFromActivePage().getInputXmlConfigFile();
        MuleConfiguration muleConfig = MessageFlowUtils.getMuleConfigFromActivePage();
        if (project != null && muleConfig != null && this.node != null) {
            this.getEventBus().fireEvent((IEvent)new MessageFlowEntityDeletedEvent(project, configFile, muleConfig, this.node));
        }
        laneDecorator.removeEntity(this.node, this.fireEvents);
        if (this.lane.getCompartmentLaneEntries().size() == 0) {
            CompartmentLane lane = (CompartmentLane)laneDecorator.getEntity();
            if (lane instanceof Route) {
                Route route = (Route)lane;
                RouteDefinition routeDefinition = route.getDefinition();
                this.laneDeleteCommand = Optional.of(new LaneDeleteCommand((CompartmentEditPart)compartmentPart, lane, Optional.of(routeDefinition)));
            } else if (compartmentPart.getParent() instanceof SplitterEditPart) {
                this.laneDeleteCommand = Optional.of(new LaneDeleteCommand((CompartmentEditPart)compartmentPart, lane, Optional.empty()));
            }
            this.laneDeleteCommand.ifPresent(command -> command.execute());
        }
        if (componentId.isDefined()) {
            ITypesManager typesManager = this.getTypesManager(project);
            this.enricher = typesManager.getEnricher(componentId);
            if (typesManager != null && this.enricher.isPresent()) {
                typesManager.removeEnricher(componentId);
                typesManager.persistCustomTypes();
            }
        }
    }

    public void undo() {
        ITypesManager typesManager;
        EntityEditPart<?> compartmentPart = MessageFlowEditor.findEditPartInRegistry(this.viewer, (IMessageFlowEntity)this.parent);
        if (compartmentPart == null) {
            return;
        }
        if (this.laneDeleteCommand.isPresent()) {
            this.laneDeleteCommand.get().undo();
        }
        IMuleProject project = MuleCorePlugin.getDesignContext().getMuleProject();
        EntityEditPart<?> lanePart = MessageFlowEditor.findEditPartInRegistry(this.viewer, (IMessageFlowEntity)this.lane);
        if (lanePart == null) {
            return;
        }
        CompartmentLaneDecorator laneDecorator = (CompartmentLaneDecorator)lanePart.getEntityDecorator();
        if (this.before != null && laneDecorator.findEntityIndex(this.before) != -1) {
            laneDecorator.addEntityAfter(this.node, this.before);
        } else if (this.after != null && laneDecorator.findEntityIndex(this.after) != -1) {
            laneDecorator.addEntityBefore(this.node, this.after);
        } else {
            laneDecorator.addEntity(this.node);
        }
        if (project != null && (typesManager = this.getTypesManager(project)) != null && this.enricher.isPresent()) {
            typesManager.enrich(this.enricher.get());
            typesManager.persistCustomTypes();
        }
    }

    private EventBus getEventBus() {
        return this.eventBus;
    }

    private ITypesManager getTypesManager(IMuleProject project) {
        return ((MetadataTypesManager)project.getProjectComponent(MetadataTypesManager.class)).getTypesManager();
    }
}

