/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.command;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.messageflow.command.CompartmentLaneCommand;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.editor.MultiPageMessageFlowEditor;
import org.mule.tooling.messageflow.editpart.CompartmentEditPart;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.decorator.CompartmentLaneDecorator;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;
import org.mule.tooling.model.module.NodeDefinition;

public class NodeCreateCommand
extends CompartmentLaneCommand {
    protected NodeDefinition definition;
    private IMessageFlowNode created;
    protected IMessageFlowEntity addBefore;

    public NodeCreateCommand(CompartmentLaneDecorator<? extends CompartmentLane> lane, NodeDefinition definition, IMessageFlowEntity addBefore) {
        super("Add " + definition.getName(), lane);
        this.definition = definition;
        this.addBefore = addBefore;
    }

    public boolean canExecute() {
        return !MessageFlowUtils.isFirstElementOnly(this.addBefore);
    }

    public void addCreatedNode(IMessageFlowNode created) {
        this.setCreated(created);
        CompartmentLaneDecorator<? extends CompartmentLane> laneDecorator = this.getCompartmentLane();
        if (this.addBefore == null) {
            laneDecorator.addEntity((IMessageFlowEntity)created);
        } else {
            laneDecorator.addEntityBefore((IMessageFlowEntity)created, this.addBefore);
        }
    }

    public void undo() {
        EntityDecorator model;
        EditPart parent;
        IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        MultiPageMessageFlowEditor editor = (MultiPageMessageFlowEditor)activeEditor;
        MessageFlowEditor messageFlowEditor = editor.getFlowEditor();
        EntityEditPart<?> entityEditPart = MessageFlowEditor.findEditPartInRegistry((EditPartViewer)messageFlowEditor.getViewer(), this.getCompartmentLane().getEntity());
        if (entityEditPart != null && (parent = entityEditPart.getParent()) instanceof CompartmentEditPart && (model = (EntityDecorator)entityEditPart.getModel()) instanceof CompartmentLaneDecorator) {
            this.setCompartmentLane((CompartmentLaneDecorator<? extends CompartmentLane>)((CompartmentLaneDecorator)model));
        }
        this.getCompartmentLane().removeEntity((MessageFlowEntity)this.created);
        this.getCompartmentLane().fireEvent("entities");
    }

    public void execute() {
        super.execute();
        MessageFlowUtils.fireCreatedEvent((IMessageFlowEntity)this.getCreated());
    }

    public boolean canRedo() {
        return true;
    }

    public void redo() {
        EntityDecorator model;
        EditPart parent;
        IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        MultiPageMessageFlowEditor editor = (MultiPageMessageFlowEditor)activeEditor;
        MessageFlowEditor messageFlowEditor = editor.getFlowEditor();
        EntityEditPart<?> entityEditPart = MessageFlowEditor.findEditPartInRegistry((EditPartViewer)messageFlowEditor.getViewer(), this.getCompartmentLane().getEntity());
        if (entityEditPart != null && (parent = entityEditPart.getParent()) instanceof CompartmentEditPart && (model = (EntityDecorator)entityEditPart.getModel()) instanceof CompartmentLaneDecorator) {
            this.setCompartmentLane((CompartmentLaneDecorator<? extends CompartmentLane>)((CompartmentLaneDecorator)model));
        }
        if (this.addBefore == null) {
            this.getCompartmentLane().addEntity((IMessageFlowEntity)this.getCreated());
        } else {
            this.getCompartmentLane().addEntityBefore((IMessageFlowEntity)this.getCreated(), this.addBefore);
        }
    }

    protected NodeDefinition getNodeDefinition() {
        return this.definition;
    }

    public void setCreated(IMessageFlowNode created) {
        this.created = created;
    }

    public IMessageFlowNode getCreated() {
        return this.created;
    }

    public IMessageFlowEntity getAddBefore() {
        return this.addBefore;
    }
}

