/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.command;

import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.event.MessageFlowEntityMoved;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.command.TransactionalSimpleCommand;
import org.mule.tooling.messageflow.util.MessageFlowEntityRef;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.EndpointDirection;
import org.mule.tooling.model.messageflow.EndpointNode;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.decorator.ContainerOfMovableEntities;
import org.mule.tooling.model.messageflow.path.MulePath;
import org.mule.tooling.utils.eventbus.IEvent;

public abstract class MoveEntityCommand
extends TransactionalSimpleCommand {
    private ContainerOfMovableEntities container;
    private IMessageFlowEntity messageFlowEntity;
    private int index;
    private int oldIndex;
    private MulePath oldPath;
    private IMessageFlowEntity afterMessageFlowEntity;
    private boolean wasInbound;

    public MoveEntityCommand(ContainerOfMovableEntities containerOfMovableEntities, IMessageFlowEntity messageFlowEntity) {
        this.container = containerOfMovableEntities;
        this.messageFlowEntity = messageFlowEntity;
        MessageFlowEntityRef oldMulePath = MessageFlowUtils.findMulePathForEntityInOpenEditors(messageFlowEntity);
        if (oldMulePath != null) {
            this.setOldPath(oldMulePath.getMulePath());
        }
    }

    public MoveEntityCommand() {
    }

    public boolean canExecute() {
        boolean isFirstElementOnly = MessageFlowUtils.isFirstElementOnly(this.getAfterMessageFlowEntity());
        return !isFirstElementOnly;
    }

    public void setAfterMessageFlowEntity(IMessageFlowEntity afterMessageFlowEntity) {
        this.afterMessageFlowEntity = afterMessageFlowEntity;
        this.index = afterMessageFlowEntity != null ? this.container.findEntityIndex(afterMessageFlowEntity) : this.container.findEntityIndex(this.container.getLastEntity());
    }

    protected synchronized void setWasInbound(boolean wasInbound) {
        this.wasInbound = wasInbound;
    }

    public synchronized boolean wasInbound() {
        return this.wasInbound;
    }

    protected synchronized boolean isInbound() {
        return this.oldIndex == 0 && this.messageFlowEntity instanceof EndpointNode && ((EndpointNode)this.messageFlowEntity).getDirection() == EndpointDirection.INBOUND;
    }

    public synchronized int getIndex() {
        return this.index;
    }

    public synchronized void setIndex(int index) {
        this.index = index;
    }

    public synchronized int getOldIndex() {
        return this.oldIndex;
    }

    public synchronized void setOldIndex(int oldIndex) {
        this.oldIndex = oldIndex;
    }

    public synchronized ContainerOfMovableEntities getContainer() {
        return this.container;
    }

    public synchronized IMessageFlowEntity getMessageFlowEntity() {
        return this.messageFlowEntity;
    }

    public synchronized IMessageFlowEntity getAfterMessageFlowEntity() {
        return this.afterMessageFlowEntity;
    }

    public synchronized void setMessageFlowEntity(IMessageFlowEntity messageFlowEntity) {
        this.messageFlowEntity = messageFlowEntity;
    }

    public synchronized void setContainer(ContainerOfMovableEntities container) {
        this.container = container;
    }

    public void comeBackToInbound() {
        if (this.wasInbound()) {
            EndpointNode endpointNode = (EndpointNode)this.getMessageFlowEntity();
            endpointNode.setDirection(EndpointDirection.INBOUND);
        }
    }

    public void execute() {
        this.doExecute();
        IMuleProject muleProject = MuleCorePlugin.getDesignContext().getMuleProject();
        MuleConfiguration muleConfig = MessageFlowUtils.getMuleConfigFromActivePage();
        MuleCorePlugin.getEventBus().fireEvent((IEvent)new MessageFlowEntityMoved(muleProject, muleConfig, this.getMessageFlowEntity(), this.getOldPath()));
    }

    protected abstract void doExecute();

    public MulePath getOldPath() {
        return this.oldPath;
    }

    public void setOldPath(MulePath oldPath) {
        this.oldPath = oldPath;
    }
}

