/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.command;

import java.util.List;
import org.mule.tooling.messageflow.command.NodeCreateCommand;
import org.mule.tooling.model.messageflow.Compartment;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.SplitterNode;
import org.mule.tooling.model.messageflow.decorator.CompartmentLaneDecorator;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitor;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitorAdapter;
import org.mule.tooling.model.module.NodeDefinition;

public class MessageFlowNodeCreateCommand
extends NodeCreateCommand {
    public MessageFlowNodeCreateCommand(CompartmentLaneDecorator<? extends CompartmentLane> lane, IMessageFlowNode created, NodeDefinition definition, IMessageFlowEntity addBefore) {
        super(lane, definition, addBefore);
        this.setCreated(created);
        this.createSubCommands();
    }

    @Override
    public boolean canExecute() {
        return true;
    }

    private void createSubCommands() {
        IMessageFlowNode created = this.getCreated();
        created.accept((MessageFlowEntityVisitor)new MessageFlowEntityVisitorAdapter(){

            public void visitCompartmentLane(CompartmentLane lane) {
                List compartmentLaneEntries = lane.getCompartmentLaneEntries();
                this.createCommands(compartmentLaneEntries);
            }

            public void visitSplitterNode(SplitterNode splitterNode) {
                splitterNode.getCompartment().accept((MessageFlowEntityVisitor)this);
            }

            public void visitNestedContainer(NestedContainer nestedContainer) {
                List compartmentLaneEntries = nestedContainer.getCompartmentLaneEntries();
                this.createCommands(compartmentLaneEntries);
            }

            private void createCommands(List<IMessageFlowEntity> compartmentLaneEntries) {
            }

            public void visitContainer(Container container) {
                List nestedContainers = container.getNestedContainers();
                for (NestedContainer nestedContainer : nestedContainers) {
                    nestedContainer.accept((MessageFlowEntityVisitor)this);
                }
            }

            public void visitCompartment(Compartment compartment) {
                List lanes = compartment.getLanes();
                for (CompartmentLane compartmentLane : lanes) {
                    compartmentLane.accept((MessageFlowEntityVisitor)this);
                }
            }
        });
    }

    @Override
    public void execute() {
        this.addCreatedNode(this.getCreated());
        super.execute();
    }
}

