/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.command;

import com.google.common.base.Optional;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.messageflow.command.DefaultMessageFlowEntityFactory;
import org.mule.tooling.messageflow.command.IMessageFlowEntityFactory;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.model.module.filter.INodeDefinitionFilter;
import org.mule.tooling.model.module.filter.ModuleManagerNodeDefinitionResolver;
import org.mule.tooling.model.module.filter.NodeDefinitionFilterFactory;

public class MessageFlowEntityFactoryManager {
    private static final String CONTAINER_TYPE_ATTRIBUTE = "containerType";
    private static final String TARGET_ATTRIBUTE = "target";
    private static final String FACTORY_CLASS_ATTRIBUTE = "factoryClass";

    public IMessageFlowEntityFactory getFactory(MessageFlowEntity container, NodeDefinition sourceDefinition) {
        IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.mule.tooling.messageflow.messageflowentityfactory");
        Optional<IMessageFlowEntityFactory> mostSpecificFactoryFound = this.createMostSpecificFactory(configurationElements, sourceDefinition, container);
        IMessageFlowEntityFactory factory = (IMessageFlowEntityFactory)mostSpecificFactoryFound.or((Object)new DefaultMessageFlowEntityFactory());
        return factory;
    }

    private Optional<IMessageFlowEntityFactory> createMostSpecificFactory(IConfigurationElement[] configurationElements, NodeDefinition sourceDefinition, MessageFlowEntity container) {
        Optional<IMessageFlowEntityFactory> lastNonSpecificFactory = Optional.absent();
        IConfigurationElement[] iConfigurationElementArray = configurationElements;
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement factoryDefinition = iConfigurationElementArray[n2];
            if (this.factoryAcceptsElement(factoryDefinition, sourceDefinition)) {
                Optional<IMessageFlowEntityFactory> specificFactory;
                String containerTypeAttribute = factoryDefinition.getAttribute(CONTAINER_TYPE_ATTRIBUTE);
                if (this.isSpecificFactoryForContainer(containerTypeAttribute, container, factoryDefinition) && (specificFactory = this.createFactory(factoryDefinition)).isPresent()) {
                    return specificFactory;
                }
                if (StringUtils.isBlank((String)containerTypeAttribute)) {
                    lastNonSpecificFactory = this.createFactory(factoryDefinition);
                }
            }
            ++n2;
        }
        return lastNonSpecificFactory;
    }

    private boolean isSpecificFactoryForContainer(String containerTypeAttribute, MessageFlowEntity container, IConfigurationElement factoryDefinition) {
        String type = MessageFlowUtils.getType((IMessageFlowEntity)container);
        return StringUtils.isNotBlank((String)type) && type.equals(containerTypeAttribute);
    }

    private boolean factoryAcceptsElement(IConfigurationElement factoryDefinition, NodeDefinition sourceDefinition) {
        String filter = factoryDefinition.getAttribute(TARGET_ATTRIBUTE);
        INodeDefinitionFilter createElementsFilter = this.createTargetFilter(filter);
        return createElementsFilter.accepts(sourceDefinition, ModuleManagerNodeDefinitionResolver.get());
    }

    private Optional<IMessageFlowEntityFactory> createFactory(IConfigurationElement factoryDefinition) {
        try {
            IMessageFlowEntityFactory factory = (IMessageFlowEntityFactory)factoryDefinition.createExecutableExtension(FACTORY_CLASS_ATTRIBUTE);
            return Optional.of((Object)factory);
        }
        catch (CoreException e) {
            MuleCorePlugin.logError((String)"Error while creating factory class", (Throwable)e);
            return Optional.absent();
        }
    }

    protected INodeDefinitionFilter createTargetFilter(String filter) {
        return NodeDefinitionFilterFactory.createFilter((String)filter);
    }
}

