/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.messageflow.command.IMessageFlowEntityAdapter;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.model.module.filter.INodeDefinitionFilter;
import org.mule.tooling.model.module.filter.ModuleManagerNodeDefinitionResolver;
import org.mule.tooling.model.module.filter.NodeDefinitionFilterFactory;

public class MessageFlowEntityAdapterManager {
    private static MessageFlowEntityAdapterManager instance = new MessageFlowEntityAdapterManager();
    private List<AdapterHolder> adapters;

    private MessageFlowEntityAdapterManager() {
        this.init();
    }

    public static MessageFlowEntityAdapterManager get() {
        return instance;
    }

    private void init() {
        IConfigurationElement[] adapters;
        this.adapters = new ArrayList<AdapterHolder>();
        IConfigurationElement[] iConfigurationElementArray = adapters = Platform.getExtensionRegistry().getConfigurationElementsFor("org.mule.tooling.messageflow.messageflowentityadapter");
        int n = adapters.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement adapter = iConfigurationElementArray[n2];
            try {
                Object adapterTo = adapter.createExecutableExtension("adapterToClass");
                Object adapterBack = adapter.createExecutableExtension("adapterBackClass");
                String from = adapter.getAttribute("from");
                String to = adapter.getAttribute("to");
                this.adapters.add(new AdapterHolder(NodeDefinitionFilterFactory.createFilter((String)to), (IMessageFlowEntityAdapter)adapterTo));
                this.adapters.add(new AdapterHolder(NodeDefinitionFilterFactory.createFilter((String)from), (IMessageFlowEntityAdapter)adapterBack));
            }
            catch (CoreException e) {
                MuleCorePlugin.logError((String)"Unable to load adapter", (Throwable)e);
            }
            ++n2;
        }
    }

    public boolean hasAdapter(NodeDefinition target, IMessageFlowEntity toAdapt) {
        return this.getAdapter(target, toAdapt) != null;
    }

    public IMessageFlowEntityAdapter getAdapter(NodeDefinition target, IMessageFlowEntity toAdapt) {
        if (this.adapters == null) {
            this.init();
        }
        for (AdapterHolder adapterHolder : this.adapters) {
            boolean acceptsTarget = adapterHolder.getTarget().accepts(null, target, ModuleManagerNodeDefinitionResolver.get());
            if (!adapterHolder.getAdapter().canAdapt(toAdapt) || !acceptsTarget) continue;
            return adapterHolder.getAdapter();
        }
        return null;
    }

    private static class AdapterHolder {
        private INodeDefinitionFilter target;
        private IMessageFlowEntityAdapter adapter;

        public AdapterHolder(INodeDefinitionFilter target, IMessageFlowEntityAdapter adapter) {
            this.target = target;
            this.adapter = adapter;
        }

        public INodeDefinitionFilter getTarget() {
            return this.target;
        }

        public IMessageFlowEntityAdapter getAdapter() {
            return this.adapter;
        }
    }
}

