/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.command;

import java.util.List;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.gef.commands.Command;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.dom.INodeWrapper;
import org.mule.tooling.core.event.MessageFlowEntityDeletedEvent;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.editpart.CompartmentEditPart;
import org.mule.tooling.messageflow.editpart.SplitterCompartmentEditPart;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.decorator.CompartmentDecorator;
import org.mule.tooling.model.module.RouteDefinition;
import org.mule.tooling.utils.eventbus.IEvent;

public class LaneDeleteCommand
extends Command {
    private Optional<RouteDefinition> routeDefinition;
    private CompartmentDecorator compartmentDecorator;
    private CompartmentLane lane;
    private CompartmentEditPart compartmentEditPart;
    private int indexOf;

    public LaneDeleteCommand(CompartmentEditPart compartmentEditPart, CompartmentLane lane, Optional<RouteDefinition> routeDefinition) {
        this.compartmentEditPart = compartmentEditPart;
        this.compartmentDecorator = compartmentEditPart.getEntityDecorator();
        this.lane = lane;
        this.routeDefinition = routeDefinition;
    }

    public void execute() {
        IElementWrapper laneElement = this.lane.getElement();
        IElementWrapper parentElement = laneElement.getParent();
        if (parentElement != null) {
            this.indexOf = parentElement.getChildElements().indexOf((INodeWrapper)laneElement);
        }
        if (this.routeDefinition.isPresent()) {
            LaneDeleteCommand.removeRouterLane(this.compartmentDecorator, this.lane, this.routeDefinition.get());
        } else {
            LaneDeleteCommand.removeLane(this.compartmentDecorator, this.lane);
        }
    }

    private static void notifyDeleted(IMessageFlowEntity node) {
        IMuleProject project = MuleCorePlugin.getDesignContext().getMuleProject();
        IFile configFile = MessageFlowUtils.getFlowEditorFromActivePage().getInputXmlConfigFile();
        MuleConfiguration muleConfig = MessageFlowUtils.getMuleConfigFromActivePage();
        if (project != null && muleConfig != null && node != null) {
            MuleCorePlugin.getEventBus().fireEvent((IEvent)new MessageFlowEntityDeletedEvent(project, configFile, muleConfig, node));
        }
    }

    public void undo() {
        IMuleProject project = MuleCorePlugin.getDesignContext().getMuleProject();
        if (this.lane.getCompartmentLaneEntries().isEmpty()) {
            MessageFlowUtils.generateSplitterLaneXml(project, this.compartmentEditPart, this.lane).ifPresent(arg_0 -> ((CompartmentLane)this.lane).setElement(arg_0));
        }
        this.compartmentDecorator.addLane(this.indexOf, this.lane);
    }

    public static void removeRouterLane(CompartmentDecorator compDecorator, CompartmentLane lane, RouteDefinition routeDefinition) {
        List lanes = compDecorator.getLanes();
        if (SplitterCompartmentEditPart.canDelete(routeDefinition, lanes)) {
            LaneDeleteCommand.removeLane(compDecorator, lane);
        }
    }

    public static void removeLane(CompartmentDecorator compDecorator, CompartmentLane lane) {
        compDecorator.removeLane(lane);
        LaneDeleteCommand.notifyDeleted((IMessageFlowEntity)lane);
    }
}

