/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.command;

import org.eclipse.gef.commands.CompoundCommand;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.generator.IFlowTransformerContext;
import org.mule.tooling.core.generator.NewFlowTransformerContext;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.command.AddTopLevelFlowCommand;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.FlowNestedContainerPos;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MessageFlowFactory;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.decorator.MuleConfigurationDecorator;
import org.mule.tooling.model.messageflow.decorator.NestedContainerDecorator;
import org.mule.tooling.model.module.ContainerDefinition;
import org.mule.tooling.model.module.GraphicalContainerDefinition;

public class InitialNodeCreateCommand
extends CompoundCommand {
    private MuleConfigurationDecorator decorator;
    private int insertPosition;
    private IMessageFlowNode node;
    private FlowNestedContainerPos nestedContainerPos;

    public InitialNodeCreateCommand(MuleConfigurationDecorator parent, IMessageFlowNode node, int insertPosition, FlowNestedContainerPos nestedContainer) {
        super("Add " + node.getName());
        this.decorator = parent;
        this.insertPosition = insertPosition;
        this.node = node;
        this.nestedContainerPos = nestedContainer;
        this.createSubcommands();
    }

    protected void createSubcommands() {
        ContainerDefinition definition = (ContainerDefinition)MuleCorePlugin.getModuleManager().getDefinition("http://www.mulesoft.org/schema/mule/core/flow");
        IFlowTransformerContext context = NewFlowTransformerContext.create((IMuleProject)MuleCorePlugin.getDesignContext().getMuleProject(), (MuleConfiguration)((MuleConfiguration)this.decorator.getEntity()));
        Container flow = MessageFlowFactory.createContainer((IFlowTransformerContext)context, (MuleConfiguration)((MuleConfiguration)this.decorator.getEntity()), (ContainerDefinition)definition);
        GraphicalContainerDefinition containerDefinition = (GraphicalContainerDefinition)definition.getGraphicalContainerDefinitions().get(this.nestedContainerPos.get());
        NestedContainer nestedContainer = flow.getNestedContainer(containerDefinition.getId());
        NestedContainerDecorator decorator = (NestedContainerDecorator)MessageFlowFactory.getWrappedEntity((IMessageFlowEntity)nestedContainer);
        decorator.addEntity((IMessageFlowEntity)this.node);
        AddTopLevelFlowCommand addTopLevel = new AddTopLevelFlowCommand(this.getConfiguration(), flow, this.insertPosition);
        this.add(addTopLevel);
    }

    public void execute() {
        super.execute();
        MessageFlowUtils.fireCreatedEvent((IMessageFlowEntity)this.node);
    }

    protected MuleConfigurationDecorator getConfiguration() {
        return this.decorator;
    }
}

