/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.command;

import org.eclipse.gef.commands.CompoundCommand;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.messageflow.command.AddTopLevelFlowCommand;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.decorator.MuleConfigurationDecorator;
import org.mule.tooling.model.module.ContainerDefinition;

public class InitialContainerCreateCommand
extends CompoundCommand {
    private MuleConfigurationDecorator muleConfigurationDecorator;
    private ContainerDefinition containerDefinition;
    private int insertPosition;
    private IMessageFlowNode createdNode;

    public InitialContainerCreateCommand(MuleConfigurationDecorator muleConfigurationDecorator, ContainerDefinition containerDefinition, int insertPosition, IMessageFlowNode createdNode) {
        super("Add Endpoint");
        this.muleConfigurationDecorator = muleConfigurationDecorator;
        this.containerDefinition = containerDefinition;
        this.insertPosition = insertPosition;
        this.createdNode = createdNode;
        this.createSubcommands();
    }

    protected void createSubcommands() {
        if (this.createdNode instanceof Container) {
            AddTopLevelFlowCommand addTopLevel = new AddTopLevelFlowCommand(this.getConfiguration(), (Container)this.createdNode, this.insertPosition);
            this.add(addTopLevel);
        } else {
            MuleCorePlugin.logError((String)("The created object for the definition " + this.containerDefinition.getId() + " should be an instance of " + String.valueOf(Container.class)), (Throwable)new IllegalStateException());
        }
    }

    public void execute() {
        super.execute();
        MessageFlowUtils.fireCreatedEvent((IMessageFlowEntity)this.createdNode);
    }

    protected MuleConfigurationDecorator getConfiguration() {
        return this.muleConfigurationDecorator;
    }
}

