/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.command;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.eclipse.gef.EditPart;
import org.mule.tooling.core.ModelUtils;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.generator.IFlowTransformerContext;
import org.mule.tooling.core.generator.NewFlowTransformerContext;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.command.AbstractWrapEntityInContainerCommand;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.events.RefreshRequestedEvent;
import org.mule.tooling.metadata.custom.metadata.assistant.CustomMetadataAssistantService;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.IPropertyCollectionReadCapability;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowFactory;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.PatternNode;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.decorator.MuleConfigurationDecorator;
import org.mule.tooling.model.messageflow.decorator.NestedContainerDecorator;
import org.mule.tooling.model.messageflow.util.PropertiesUtils;
import org.mule.tooling.model.module.ContainerDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.model.module.filter.ModuleManagerNodeDefinitionResolver;
import org.mule.tooling.utils.eventbus.IEvent;

public class ExtractEntityToNewFlowNodeCommand
extends AbstractWrapEntityInContainerCommand {
    private String flowName;
    private PatternNode flowRef;
    private MuleConfiguration targetMuleConfiguration;
    private IMuleProject muleProject;
    private NestedContainerDecorator nestedContainerDecorator;

    public ExtractEntityToNewFlowNodeCommand(IMuleProject muleProject, MuleConfiguration muleConfiguration, MuleConfiguration targetMuleConfiguration, ContainerDefinition nodeDefinition) {
        super(muleConfiguration, nodeDefinition);
        this.muleProject = muleProject;
        this.targetMuleConfiguration = targetMuleConfiguration;
    }

    @Override
    public boolean validate() {
        if (this.getEntityEditParts().isEmpty()) {
            return false;
        }
        EntityEditPart<MessageFlowEntity> firstEditPart = this.getFirstEditPart();
        EditPart parentEditPart = firstEditPart.getParent();
        for (EntityEditPart<?> entityEditPart : this.getEntityEditParts()) {
            boolean acceptsChild;
            if (!(entityEditPart.getEntity() instanceof IMessageFlowNode)) {
                return false;
            }
            if (entityEditPart.getParent() != parentEditPart) {
                return false;
            }
            IMessageFlowNode guestNode = (IMessageFlowNode)entityEditPart.getEntity();
            ContainerDefinition containerDefinition = (ContainerDefinition)this.getNodeDefinition();
            IFlowTransformerContext context = NewFlowTransformerContext.create((IMuleProject)this.muleProject, (MuleConfiguration)this.targetMuleConfiguration);
            Container host = MessageFlowFactory.createContainer((IFlowTransformerContext)context, (MuleConfiguration)this.getMuleConfiguration(), (ContainerDefinition)containerDefinition);
            NodeDefinition guest = guestNode.getDefinition();
            boolean bl = acceptsChild = ModelUtils.isComment((IMessageFlowEntity)guestNode) || containerDefinition.getDefaultContainerDefinition().getAcceptsFilter().accepts((IMessageFlowNode)host, guest, ModuleManagerNodeDefinitionResolver.get());
            if (acceptsChild) continue;
            return false;
        }
        return true;
    }

    public void execute() {
        ArrayList<QName> qNames = new ArrayList<QName>();
        for (MessageFlowEntity entity : this.entities.values()) {
            qNames.add(entity.getElement().getQName());
        }
        this.removeElements(true);
        ContainerDefinition containerDefinition = (ContainerDefinition)this.getNodeDefinition();
        this.createdContainer = MessageFlowFactory.createContainer((IFlowTransformerContext)NewFlowTransformerContext.create((IMuleProject)this.muleProject, (MuleConfiguration)this.targetMuleConfiguration), (MuleConfiguration)this.targetMuleConfiguration, (ContainerDefinition)containerDefinition);
        this.createdContainer.setName(this.flowName);
        NestedContainer nestedContainer = this.createdContainer.getNestedContainer(containerDefinition.getDefaultContainerDefinition().getId());
        this.nestedContainerDecorator = (NestedContainerDecorator)MessageFlowFactory.getWrappedEntity((IMessageFlowEntity)nestedContainer);
        for (QName qname : qNames) {
            ((NestedContainer)this.nestedContainerDecorator.getEntity()).getElement().setQName(qname);
        }
        for (MessageFlowEntity entity : this.entities.values()) {
            this.nestedContainerDecorator.addEntity((IMessageFlowEntity)entity);
        }
        NodeDefinition flowRefDef = MuleCorePlugin.getModuleManager().getDefinition("http://www.mulesoft.org/schema/mule/core/flow-ref");
        IFlowTransformerContext context = NewFlowTransformerContext.create((IMuleProject)this.muleProject, (MuleConfiguration)this.targetMuleConfiguration);
        this.flowRef = MessageFlowFactory.createPatternNode((IFlowTransformerContext)context, (NodeDefinition)flowRefDef);
        PropertyCollection flowPropertyCollection = PropertiesUtils.toWritablePropertyCollection((IPropertyCollectionReadCapability)this.flowRef.getProperties());
        flowPropertyCollection.setProperty("name", this.createdContainer.getName());
        this.flowRef.setProperties(flowPropertyCollection);
        Integer index = (Integer)this.entities.entrySet().iterator().next().getKey();
        this.getContainer().addEntity(index.intValue(), (IMessageFlowEntity)this.flowRef);
        this.getTargetMuleConfigurationDecorator().addEntity(0, (IMessageFlowEntity)this.createdContainer);
        MuleCorePlugin.getEventBus().fireEvent((IEvent)new RefreshRequestedEvent());
    }

    public void undo() {
        for (MessageFlowEntity entity : this.entities.values()) {
            this.nestedContainerDecorator.removeEntity(entity);
        }
        this.getTargetMuleConfigurationDecorator().removeEntity((IMessageFlowEntity)this.createdContainer, true);
        this.getContainer().removeEntity((IMessageFlowEntity)this.flowRef, true);
        this.putElementsBack();
        MuleCorePlugin.getEventBus().fireEvent((IEvent)new RefreshRequestedEvent());
        ((CustomMetadataAssistantService)this.muleProject.getProjectComponent(CustomMetadataAssistantService.class)).deleteAutogeneratedMetadataByDocId(this.createdContainer.getElement().getAttributeValue("doc:id"), "");
    }

    public void setFlowName(String flowName) {
        this.flowName = flowName;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public void setFlowRef(PatternNode flowRef) {
        this.flowRef = flowRef;
    }

    public PatternNode getFlowRef() {
        return this.flowRef;
    }

    public MuleConfigurationDecorator getTargetMuleConfigurationDecorator() {
        return new MuleConfigurationDecorator(this.targetMuleConfiguration);
    }
}

