/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.command;

import org.eclipse.gef.EditPart;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.generator.IFlowTransformerContext;
import org.mule.tooling.core.generator.NewFlowTransformerContext;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.command.NodeCreateCommand;
import org.mule.tooling.model.messageflow.Compartment;
import org.mule.tooling.model.messageflow.EndpointDirection;
import org.mule.tooling.model.messageflow.EndpointNode;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MessageFlowFactory;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.decorator.CompartmentLaneDecorator;
import org.mule.tooling.model.messageflow.decorator.MuleConfigurationDecorator;
import org.mule.tooling.model.module.EndpointDefinition;
import org.mule.tooling.model.module.NodeDefinition;

public class EndpointCreateCommand
extends NodeCreateCommand {
    private IMessageFlowEntity addAfter;
    private EditPart compartmentLaneParent;
    private MuleConfigurationDecorator muleConfigurationDecorator;

    public EndpointCreateCommand(MuleConfigurationDecorator muleConfigurationDecorator, CompartmentLaneDecorator<?> lane, EndpointDefinition endpoint, IMessageFlowEntity addAfter, IMessageFlowEntity addBefore, EditPart parent) {
        super(lane, (NodeDefinition)endpoint, addBefore);
        this.addAfter = addAfter;
        this.setCompartmentLaneParent(parent);
        this.muleConfigurationDecorator = muleConfigurationDecorator;
    }

    @Override
    public boolean canExecute() {
        if (!super.canExecute()) {
            return false;
        }
        if (this.addAfter instanceof Compartment) {
            return false;
        }
        EndpointDirection direction = EndpointDirection.OUTBOUND;
        EndpointDefinition edefinition = (EndpointDefinition)this.definition;
        if (direction == EndpointDirection.OUTBOUND) {
            return edefinition.isSupportsOutbound();
        }
        return true;
    }

    @Override
    public void execute() {
        IFlowTransformerContext context = NewFlowTransformerContext.create((IMuleProject)MuleCorePlugin.getDesignContext().getMuleProject(), (MuleConfiguration)((MuleConfiguration)this.muleConfigurationDecorator.getEntity()));
        EndpointNode created = MessageFlowFactory.createEndpointNode((IFlowTransformerContext)context, (EndpointDefinition)this.getEndpointDefinition(), (EndpointDirection)EndpointDirection.OUTBOUND);
        this.addCreatedNode((IMessageFlowNode)created);
        super.execute();
    }

    protected EndpointDefinition getEndpointDefinition() {
        return (EndpointDefinition)this.getNodeDefinition();
    }

    public void setCompartmentLaneParent(EditPart compartmentLaneParent) {
        this.compartmentLaneParent = compartmentLaneParent;
    }

    public EditPart getCompartmentLaneParent() {
        return this.compartmentLaneParent;
    }
}

