/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.command;

import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.command.UpdateFlowsCommand;
import org.mule.tooling.messageflow.command.UpdatePropertiesCommand;
import org.mule.tooling.messageflow.editor.GlobalElementEditor;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.IReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;
import org.mule.tooling.model.messageflow.decorator.MuleConfigurationDecorator;

public class EditGlobalElementsCommand
extends CompoundCommand {
    private final GlobalElementEditor.PropertyTransformer propertyTransformer;
    private final EntityDecorator<GlobalElement> elementDecorator;
    private final IReadOnlyPropertyCollection oldProperties;
    private final PropertyCollection newProperties;
    private MuleConfigurationDecorator decorator;
    private IMuleProject muleProject;

    public EditGlobalElementsCommand(IMuleProject muleProject, MuleConfigurationDecorator decorator, GlobalElementEditor.PropertyTransformer propertyTransformer, IReadOnlyPropertyCollection old, PropertyCollection updated, EntityDecorator<GlobalElement> elementDecorator) {
        this.muleProject = muleProject;
        this.decorator = decorator;
        this.propertyTransformer = propertyTransformer;
        this.oldProperties = old;
        this.newProperties = updated;
        this.elementDecorator = elementDecorator;
        this.createSubCommands();
    }

    public void createSubCommands() {
        if (this.propertyTransformer != null) {
            this.add((Command)new UpdateFlowsCommand(this.muleProject, this.propertyTransformer, this.decorator));
        }
        this.add(new UpdatePropertiesCommand<GlobalElement>(this.muleProject, this.decorator, this.elementDecorator, this.oldProperties, this.newProperties));
    }
}

