/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.command;

import org.eclipse.core.resources.IFile;
import org.eclipse.gef.commands.Command;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.dom.INodeWrapper;
import org.mule.tooling.core.event.MessageFlowEntityDeletedEvent;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.metadata.custom.metadata.assistant.CustomMetadataAssistantService;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.decorator.MuleConfigurationDecorator;
import org.mule.tooling.utils.eventbus.IEvent;

public class DeleteFlowCommand
extends Command {
    private MuleConfigurationDecorator decorator;
    private Container element;
    private int indexOf;

    public DeleteFlowCommand(MuleConfigurationDecorator parent, Container element) {
        super("Delete Flow");
        this.decorator = parent;
        this.element = element;
    }

    public void execute() {
        IElementWrapper elementWrapper = this.element.getElement();
        IElementWrapper parentWrapper = elementWrapper.getParent();
        this.indexOf = parentWrapper.getChildElements().indexOf((INodeWrapper)elementWrapper);
        this.decorator.removeFlow(this.element);
        IFile configFile = MessageFlowUtils.getFlowEditorFromActivePage().getInputXmlConfigFile();
        MuleConfiguration muleConfig = MessageFlowUtils.getMuleConfigFromActivePage();
        IMuleProject project = MuleCorePlugin.getDesignContext().getMuleProject();
        if (project != null && muleConfig != null) {
            MuleCorePlugin.getEventBus().fireEvent((IEvent)new MessageFlowEntityDeletedEvent(project, configFile, muleConfig, (IMessageFlowEntity)this.element));
        }
        ((CustomMetadataAssistantService)project.getProjectComponent(CustomMetadataAssistantService.class)).deleteAutogeneratedMetadataByDocId(elementWrapper.getAttributeValue("doc:id"), this.element.toString());
    }

    public void undo() {
        this.decorator.addEntity(this.indexOf, (IMessageFlowEntity)this.element);
    }
}

