/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.command;

import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.generator.IFlowTransformerContext;
import org.mule.tooling.core.generator.NewFlowTransformerContext;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.command.IMessageFlowEntityFactory;
import org.mule.tooling.model.messageflow.EndpointDirection;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowFactory;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.util.NodeDefinitionVisitor;
import org.mule.tooling.model.messageflow.util.NodeDefinitionVisitorAdapter;
import org.mule.tooling.model.module.ContainerDefinition;
import org.mule.tooling.model.module.EndpointDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.model.module.PatternDefinition;
import org.mule.tooling.model.module.SplitterDefinition;
import org.mule.tooling.utils.ObjectHolder;

public class DefaultMessageFlowEntityFactory
implements IMessageFlowEntityFactory {
    public MessageFlowNode create(final MuleConfiguration muleConfiguration, IMessageFlowEntity container, NodeDefinition target, IMessageFlowEntity beforeMessageFlowEntity, IMessageFlowEntity afterMessageFlowEntity) {
        final ObjectHolder result = new ObjectHolder();
        final IFlowTransformerContext context = NewFlowTransformerContext.create((IMuleProject)MuleCorePlugin.getDesignContext().getMuleProject(), (MuleConfiguration)muleConfiguration);
        target.accept((NodeDefinitionVisitor)new NodeDefinitionVisitorAdapter(){

            public void visitPatternDefinition(PatternDefinition patternDefinition) {
                if (patternDefinition.isCausesSplit()) {
                    result.set((Object)MessageFlowFactory.createSplitterNode((IFlowTransformerContext)context, (NodeDefinition)patternDefinition));
                } else {
                    result.set((Object)MessageFlowFactory.createPatternNode((IFlowTransformerContext)context, (NodeDefinition)patternDefinition));
                }
            }

            public void visitEndpointDefinition(EndpointDefinition endpointDefinition) {
                boolean outboundOnlyEndpoint = !endpointDefinition.isSupportsInbound() && endpointDefinition.isSupportsOutbound();
                EndpointDirection direction = outboundOnlyEndpoint ? EndpointDirection.OUTBOUND : EndpointDirection.INBOUND;
                result.set((Object)MessageFlowFactory.createEndpointNode((IFlowTransformerContext)context, (EndpointDefinition)endpointDefinition, (EndpointDirection)direction));
            }

            public void visitContainerDefinition(ContainerDefinition containerDefinition) {
                result.set((Object)MessageFlowFactory.createContainer((IFlowTransformerContext)context, (MuleConfiguration)muleConfiguration, (ContainerDefinition)containerDefinition));
            }

            public void visitSplitterDefinition(SplitterDefinition splitterDefinition) {
                result.set((Object)MessageFlowFactory.createSplitterNode((IFlowTransformerContext)context, (NodeDefinition)splitterDefinition));
            }
        });
        return (MessageFlowNode)result.get();
    }
}

