/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.command;

import org.eclipse.gef.EditPart;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.generator.IFlowTransformerContext;
import org.mule.tooling.core.generator.NewFlowTransformerContext;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.command.AddCompartmentLaneCommand;
import org.mule.tooling.messageflow.command.CloneEntityCommand;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.editpart.SplitterEditPart;
import org.mule.tooling.messageflow.util.CloneEntityVisitor;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowFactory;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.decorator.CompartmentDecorator;
import org.mule.tooling.model.messageflow.decorator.CompartmentLaneDecorator;
import org.mule.tooling.model.messageflow.decorator.ContainerOfMovableEntities;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitor;

public class CloneEntityToFlowControlCommand
extends CloneEntityCommand {
    private CompartmentDecorator compartment;
    private EditPart rootEditPart;
    private CloneEntityVisitor cloneEntityVisitor;
    private SplitterEditPart splitterEditPart;

    public CloneEntityToFlowControlCommand(SplitterEditPart splitterEditPart, CompartmentDecorator compartment, EditPart editPart, IMessageFlowEntity messageFlowEntity, CloneEntityVisitor cloneEntityVisitor) {
        this.splitterEditPart = splitterEditPart;
        this.compartment = compartment;
        this.rootEditPart = editPart;
        this.setMessageFlowEntity(messageFlowEntity);
        this.cloneEntityVisitor = cloneEntityVisitor;
    }

    @Override
    public void execute() {
        CompartmentLane emptyLane;
        if (this.isInterruptedExecution()) {
            return;
        }
        if (this.getMessageFlowEntity() instanceof MessageFlowNode) {
            ((MessageFlowNode)this.getMessageFlowEntity()).accept((MessageFlowEntityVisitor)this.cloneEntityVisitor);
            this.setMessageFlowEntity((IMessageFlowEntity)this.cloneEntityVisitor.retrieveClonedEntity());
        }
        if ((emptyLane = this.compartment.getEmptyLane()) != null) {
            EntityEditPart<?> emptyLanePart = MessageFlowEditor.findEditPartInRegistry(this.rootEditPart.getViewer(), (IMessageFlowEntity)emptyLane);
            this.setContainer((ContainerOfMovableEntities)((CompartmentLaneDecorator)emptyLanePart.getEntityDecorator()));
        } else {
            this.addLaneToCompartment();
        }
        int targetIndex = this.getIndex();
        this.getContainer().addEntity(targetIndex, this.getMessageFlowEntity());
        MessageFlowUtils.fireCreatedEvent(this.getMessageFlowEntity());
    }

    protected void addLaneToCompartment() {
        this.resetCompartment();
        CompartmentLane lane = this.addNewLane(this.compartment);
        EntityEditPart<?> lanePart = MessageFlowEditor.findEditPartInRegistry(this.rootEditPart.getViewer(), (IMessageFlowEntity)lane);
        CompartmentLaneDecorator laneDecorator = (CompartmentLaneDecorator)lanePart.getEntityDecorator();
        this.setContainer((ContainerOfMovableEntities)laneDecorator);
    }

    public void resetCompartment() {
        EntityEditPart<?> compartmentPart = MessageFlowEditor.findEditPartInRegistry(this.rootEditPart.getViewer(), this.compartment.getEntity());
        EntityDecorator<?> compartmentDecorator = compartmentPart.getEntityDecorator();
        this.compartment = (CompartmentDecorator)compartmentDecorator;
    }

    public CompartmentLane addNewLane(Object compartment) {
        IFlowTransformerContext context = NewFlowTransformerContext.create((IMuleProject)MuleCorePlugin.getDesignContext().getMuleProject(), (MuleConfiguration)this.splitterEditPart.getMuleConfiguration());
        CompartmentLane lane = MessageFlowFactory.createCompartmentLane((IFlowTransformerContext)context);
        AddCompartmentLaneCommand addLane = new AddCompartmentLaneCommand((CompartmentDecorator)compartment, lane);
        addLane.execute();
        return lane;
    }
}

