/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.command;

import org.mule.tooling.messageflow.command.MoveEntityCommand;
import org.mule.tooling.messageflow.util.CloneEntityVisitor;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.decorator.ContainerOfMovableEntities;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitor;

public class CloneEntityCommand
extends MoveEntityCommand {
    private CloneEntityVisitor cloneEntityVisitor;

    public CloneEntityCommand() {
    }

    public CloneEntityCommand(ContainerOfMovableEntities model, IMessageFlowEntity messageFlowEntity, CloneEntityVisitor cloneEntityVisitor) {
        super(model, messageFlowEntity);
        this.cloneEntityVisitor = cloneEntityVisitor;
    }

    @Override
    public boolean canExecute() {
        return super.canExecute() && this.getMessageFlowEntity() instanceof MessageFlowNode;
    }

    @Override
    public void execute() {
        this.doExecute();
    }

    @Override
    protected void doExecute() {
        if (this.isInterruptedExecution()) {
            return;
        }
        ((MessageFlowNode)this.getMessageFlowEntity()).accept((MessageFlowEntityVisitor)this.cloneEntityVisitor);
        this.setMessageFlowEntity((IMessageFlowEntity)this.cloneEntityVisitor.retrieveClonedEntity());
        int targetIndex = this.getIndex();
        if (this.getAfterMessageFlowEntity() == null) {
            ++targetIndex;
        }
        this.getContainer().addEntity(targetIndex, this.getMessageFlowEntity());
        MessageFlowUtils.fireCreatedEvent(this.getMessageFlowEntity());
    }

    public void undo() {
        if (this.isInterruptedExecution()) {
            return;
        }
        this.getContainer().removeEntity(this.getMessageFlowEntity(), true);
    }
}

