/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.command;

import org.eclipse.gef.commands.Command;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.dom.w3c.impl.AbstractNodeWrapperW3C;
import org.mule.tooling.core.dom.w3c.impl.ElementWrapperW3C;
import org.mule.tooling.core.dom.w3c.impl.W3CNodeUtils;
import org.mule.tooling.core.generator.INodeXmlGenerator;
import org.mule.tooling.core.generator.NewFlowTransformerContext;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.MuleConfigurationXmlGenerator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AppendChildCommand
extends Command {
    MessageFlowEntity child;
    IElementWrapper parent;
    IMuleProject project;
    MuleConfiguration muleConfiguration;
    boolean existingBefore;
    String name;

    public AppendChildCommand(MessageFlowEntity child, IElementWrapper parent, IMuleProject project, MuleConfiguration muleConfiguration, String name) {
        this.child = child;
        this.parent = parent;
        this.project = project;
        this.muleConfiguration = muleConfiguration;
        this.name = name;
    }

    public boolean canExecute() {
        return this.child instanceof IMessageFlowNode && this.parent instanceof ElementWrapperW3C;
    }

    public void execute() {
        INodeXmlGenerator generator = MuleConfigurationXmlGenerator.getGeneratorForNode((IMessageFlowNode)((IMessageFlowNode)this.child));
        Element parentNode = ((ElementWrapperW3C)this.parent).getNode();
        NodeList children = parentNode.getChildNodes();
        this.existingBefore = false;
        int i = 0;
        while (i < children.getLength()) {
            if (children.item(i).getLocalName() != null && children.item(i).getLocalName().equals(this.name)) {
                this.existingBefore = true;
                break;
            }
            ++i;
        }
        if (!this.existingBefore) {
            IElementWrapper childWrapper = generator.generate(this.child, NewFlowTransformerContext.create((IMuleProject)this.project, (MuleConfiguration)this.muleConfiguration));
            W3CNodeUtils.appendChild((Element)parentNode, (AbstractNodeWrapperW3C)((AbstractNodeWrapperW3C)childWrapper));
        }
    }

    public void undo() {
        if (!this.existingBefore) {
            Element parentNode = ((ElementWrapperW3C)this.parent).getNode();
            NodeList children = parentNode.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                if (children.item(i).getLocalName() != null && children.item(i).getLocalName().equals(this.name)) {
                    W3CNodeUtils.removeChild((Element)((ElementWrapperW3C)this.parent).getNode(), (Node)children.item(i));
                }
                ++i;
            }
        }
    }
}

