/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.command;

import java.util.Optional;
import org.eclipse.gef.commands.Command;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.Compartment;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowFactory;
import org.mule.tooling.model.messageflow.decorator.CompartmentDecorator;
import org.mule.tooling.model.messageflow.decorator.CompartmentLaneDecorator;

public class AddCompartmentLaneCommand
extends Command {
    private CompartmentDecorator compartment;
    private CompartmentLane lane;
    private CompartmentLaneDecorator<CompartmentLane> laneDecorator;

    public AddCompartmentLaneCommand(CompartmentDecorator compartment, CompartmentLane lane) {
        this.compartment = compartment;
        this.lane = lane;
    }

    public AddCompartmentLaneCommand(CompartmentDecorator compartment, CompartmentLaneDecorator<CompartmentLane> laneDeco) {
        this(compartment, (CompartmentLane)laneDeco.getEntity());
        this.laneDecorator = laneDeco;
    }

    public void execute() {
        Optional entry;
        this.compartment.addLane(this.getLane());
        MessageFlowFactory.configureNextCompartmentLane((Compartment)((Compartment)this.compartment.getEntity()));
        if (this.laneDecorator != null) {
            this.laneDecorator.fireEvent("entities");
        }
        if ((entry = this.getLane().getEntry(0)).isPresent()) {
            MessageFlowUtils.fireCreatedEvent((IMessageFlowEntity)entry.get());
        }
    }

    public void undo() {
        this.compartment.removeLane(this.getLane());
    }

    public CompartmentLane getLane() {
        return this.lane;
    }
}

