/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.command;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.gef.EditPart;
import org.mule.tooling.core.ModelUtils;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.generator.IFlowTransformerContext;
import org.mule.tooling.core.generator.NewFlowTransformerContext;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.command.AbstractWrapEntityInCommand;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowFactory;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.decorator.CompartmentLaneDecorator;
import org.mule.tooling.model.module.ContainerDefinition;
import org.mule.tooling.model.module.NestedContainerDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.model.module.filter.INodeDefinitionFilter;
import org.mule.tooling.model.module.filter.ModuleManagerNodeDefinitionResolver;

public class AbstractWrapEntityInContainerCommand
extends AbstractWrapEntityInCommand<ContainerDefinition> {
    private CompartmentLaneDecorator<?> container;
    protected Map<Integer, MessageFlowEntity> entities;
    private MuleConfiguration muleConfiguration;
    protected Container createdContainer;

    public AbstractWrapEntityInContainerCommand(MuleConfiguration muleConfiguration, ContainerDefinition nodeDefinition) {
        super(nodeDefinition);
        this.muleConfiguration = muleConfiguration;
        this.entities = new TreeMap<Integer, MessageFlowEntity>();
        this.setup();
    }

    public MuleConfiguration getMuleConfiguration() {
        return this.muleConfiguration;
    }

    @Override
    public boolean canExecute() {
        return this.validate();
    }

    public boolean validate() {
        NodeDefinition definition;
        String type;
        ContainerDefinition containerDefinition = (ContainerDefinition)this.getNodeDefinition();
        if (this.getEntityEditParts().size() == 0) {
            return false;
        }
        EntityEditPart<MessageFlowEntity> firstEditPart = this.getFirstEditPart();
        EditPart parentEditPart = firstEditPart.getParent();
        for (EntityEditPart<?> entityEditPart : this.getEntityEditParts()) {
            boolean acceptsChild;
            if (!(entityEditPart.getEntity() instanceof IMessageFlowNode)) {
                return false;
            }
            if (entityEditPart.getParent() != parentEditPart) {
                return false;
            }
            IMessageFlowNode guestNode = (IMessageFlowNode)entityEditPart.getEntity();
            IFlowTransformerContext context = NewFlowTransformerContext.create((IMuleProject)MuleCorePlugin.getDesignContext().getMuleProject(), (MuleConfiguration)this.muleConfiguration);
            Container host = MessageFlowFactory.createContainer((IFlowTransformerContext)context, (MuleConfiguration)this.muleConfiguration, (ContainerDefinition)containerDefinition);
            NodeDefinition guest = guestNode.getDefinition();
            boolean bl = acceptsChild = ModelUtils.isComment((IMessageFlowEntity)guestNode) || containerDefinition.getDefaultContainerDefinition().getAcceptsFilter().accepts((IMessageFlowNode)host, guest, ModuleManagerNodeDefinitionResolver.get());
            if (acceptsChild) continue;
            return false;
        }
        IMessageFlowNode parentMessageFlowNode = MessageFlowUtils.getParentMessageFlowNode(firstEditPart);
        if (parentMessageFlowNode != null && (type = parentMessageFlowNode.getType()) != null && (definition = parentMessageFlowNode.getDefinition()) != null) {
            NestedContainer createNestedContainer;
            NestedContainerDefinition nestedContainerDefinition;
            INodeDefinitionFilter acceptsFilter;
            boolean acceptsChild;
            boolean accepts = ((ContainerDefinition)this.getNodeDefinition()).getAcceptedByFilter().accepts(parentMessageFlowNode, definition, ModuleManagerNodeDefinitionResolver.get());
            if (!accepts) {
                return false;
            }
            if (definition instanceof NestedContainerDefinition && !(acceptsChild = (acceptsFilter = (nestedContainerDefinition = (NestedContainerDefinition)definition).getAcceptsFilter()).accepts((IMessageFlowNode)(createNestedContainer = MessageFlowFactory.createNestedContainer((NestedContainerDefinition)nestedContainerDefinition)), (NodeDefinition)containerDefinition, ModuleManagerNodeDefinitionResolver.get()))) {
                return false;
            }
        }
        return super.canExecute();
    }

    public EntityEditPart<MessageFlowEntity> getFirstEditPart() {
        return this.getEntityEditParts().get(0);
    }

    public void setup() {
        MessageFlowEditor sourceOwner = this.getSourceOwnerEditor();
        this.setOwner(sourceOwner);
        List selectedEditParts = this.getOwner().getViewer().getSelectedEditParts();
        ArrayList entityEditParts = new ArrayList();
        for (Object object : selectedEditParts) {
            if (!(object instanceof EntityEditPart)) continue;
            EntityEditPart entityEditPart = (EntityEditPart)object;
            entityEditParts.add(entityEditPart);
        }
        this.setEntityEditParts(entityEditParts);
        Object parentModel = this.getFirstEditPart().getParent().getModel();
        if (parentModel instanceof CompartmentLaneDecorator) {
            this.setupParent((CompartmentLaneDecorator)parentModel);
            for (EntityEditPart<?> entityEditPart : this.getEntityEditParts()) {
                Object child = entityEditPart.getEntity();
                this.entities.put(this.getContainer().findEntityIndex(child), (MessageFlowEntity)child);
            }
        }
    }

    private MessageFlowEditor getSourceOwnerEditor() {
        return MessageFlowUtils.getOpenMessageFlowEditors().stream().filter(editor -> editor.getMuleConfiguration().equals(this.muleConfiguration)).findFirst().orElseThrow(() -> new IllegalStateException("the editor where this command was created must be open and should be found"));
    }

    public void putElementsBack() {
        Set<Map.Entry<Integer, MessageFlowEntity>> entrySet = this.entities.entrySet();
        for (Map.Entry<Integer, MessageFlowEntity> entry : entrySet) {
            this.getContainer().addEntity(entry.getKey().intValue(), (IMessageFlowEntity)entry.getValue());
        }
    }

    public void removeElements(boolean fireEvent) {
        for (MessageFlowEntity messageFlowEntity : this.entities.values()) {
            this.getContainer().removeEntity((IMessageFlowEntity)messageFlowEntity, fireEvent);
        }
    }

    public void setupParent(CompartmentLaneDecorator<?> compartmentLaneDecorator) {
        this.setContainer(compartmentLaneDecorator);
    }

    public CompartmentLaneDecorator<?> getContainer() {
        return this.container;
    }

    public void setContainer(CompartmentLaneDecorator<?> compartmentLaneDecorator) {
        this.container = compartmentLaneDecorator;
    }

    public Container getCreatedContainer() {
        return this.createdContainer;
    }
}

