/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.command;

import java.util.List;
import org.mule.tooling.core.ModelUtils;
import org.mule.tooling.messageflow.command.TransactionalSimpleCommand;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.model.messageflow.EndpointDirection;
import org.mule.tooling.model.messageflow.EndpointNode;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.model.module.filter.ModuleManagerNodeDefinitionResolver;

public class AbstractWrapEntityInCommand<T extends NodeDefinition>
extends TransactionalSimpleCommand {
    private T nodeDefinition;
    private List<EntityEditPart<?>> entityEditParts;
    private MessageFlowEditor owner;

    public AbstractWrapEntityInCommand(T nodeDefinition) {
        this.setNodeDefinition(nodeDefinition);
    }

    public void setNodeDefinition(T nodeDefinition) {
        this.nodeDefinition = nodeDefinition;
    }

    public T getNodeDefinition() {
        return this.nodeDefinition;
    }

    protected boolean allEditPartsAreInboundEndpoints(List<EntityEditPart<?>> entityEditParts) {
        for (EntityEditPart<?> entityEditPart : entityEditParts) {
            EntityDecorator entityDecorator = (EntityDecorator)entityEditPart.getModel();
            MessageFlowEntity messageFlowEntity = (MessageFlowEntity)entityDecorator.getEntity();
            if (!(messageFlowEntity instanceof EndpointNode)) {
                return false;
            }
            EndpointNode endpointNode = (EndpointNode)messageFlowEntity;
            if (endpointNode.getDirection() == EndpointDirection.INBOUND) continue;
            return false;
        }
        return true;
    }

    public void setEntityEditParts(List<EntityEditPart<?>> entityEditParts) {
        this.entityEditParts = entityEditParts;
    }

    public List<EntityEditPart<?>> getEntityEditParts() {
        return this.entityEditParts;
    }

    public void setOwner(MessageFlowEditor owner) {
        this.owner = owner;
    }

    public MessageFlowEditor getOwner() {
        return this.owner;
    }

    public boolean canExecute() {
        boolean isAccepted = true;
        for (EntityEditPart<?> entityEditPart : this.getEntityEditParts()) {
            Object entity = entityEditPart.getEntity();
            if (!(entity instanceof MessageFlowNode) || ModelUtils.isComment(entity)) continue;
            MessageFlowNode messageFlowNode = (MessageFlowNode)entity;
            NodeDefinition definition = messageFlowNode.getDefinition();
            isAccepted &= definition.getAcceptedByFilter().accepts(this.getNodeDefinition(), ModuleManagerNodeDefinitionResolver.get());
        }
        return isAccepted;
    }
}

