/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.action;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.client.TestConnectionExecutor;
import org.mule.tooling.client.api.ServiceResponse;
import org.mule.tooling.client.api.ServiceResponseFactory;
import org.mule.tooling.client.startup.ToolingManager;
import org.mule.tooling.client.startup.ToolingNotAvailableException;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.StudioDesignContextRunner;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.module.MessageFlowNodeComposite;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.metadata.utils.MetadataUtils;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.runtime.tooling.ToolingWorkspace;
import org.mule.tooling.ui.preferences.MuleStudioPreference;

public class TestConnectorConnectionFromMuleConfigAction
extends Action {
    private static final String TEST_CONN_OK_MESSAGE = "Test connection successful";
    private static final String TEST_CONN_GENERAL_ERROR_MESSAGE = "Error while doing connectivity test";
    public static final String TEST_CONNECTION = "Test connection";
    private final IMuleProject muleProject;
    private ServiceResponse<?> connectionResult;
    private boolean interrupted;
    private final MuleConfiguration muleConfiguration;
    private final MessageFlowNode globalElement;
    private final List<MessageFlowNodeComposite> contributedPages;

    public TestConnectorConnectionFromMuleConfigAction(IMuleProject muleProject, MuleConfiguration muleConfiguration, MessageFlowNode globalElement, List<MessageFlowNodeComposite> contributedPages) {
        this.contributedPages = contributedPages;
        this.muleProject = muleProject;
        this.muleConfiguration = muleConfiguration;
        this.globalElement = globalElement;
    }

    public boolean isEnabled() {
        return this.getMuleProject().getServerDefinition().compareVersionTo("3.4.0") >= 0;
    }

    public void run() {
        Shell activeShell = Display.getDefault().getActiveShell();
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(activeShell);
        try {
            progressMonitorDialog.run(true, true, progressMonitor -> StudioDesignContextRunner.runSilentWithMuleProject(() -> {
                Thread testConnectionThread = new Thread((Runnable)new TestConnectionRunnable(progressMonitor), "TestConnectionThread");
                testConnectionThread.start();
                while (testConnectionThread.isAlive()) {
                    if (progressMonitor.isCanceled()) {
                        testConnectionThread.interrupt();
                        this.setInterrupted(true);
                        break;
                    }
                    testConnectionThread.join(500L);
                }
                return null;
            }, (IMuleProject)this.getMuleProject()));
        }
        catch (InterruptedException | InvocationTargetException e) {
            MuleCorePlugin.logError((String)"Invocation test connection failure.", (Throwable)e);
            this.connectionResult = ServiceResponseFactory.failure((Exception)e);
        }
        if (!this.isInterrupted()) {
            this.displayResultMessage(activeShell);
        }
    }

    private int getTimeoutInMilliseconds() {
        return MuleStudioPreference.getDatasenseTimeoutInSeconds() * 1000;
    }

    private void displayResultMessage(Shell parent) {
        if (this.connectionResult.isSuccess()) {
            MessageDialog.openInformation((Shell)parent, (String)TEST_CONNECTION, (String)TEST_CONN_OK_MESSAGE);
        } else {
            MetadataUtils.showTestConnectionErrorMessage((String)this.connectionResult.getMessage(), (String)this.connectionResult.getStackTrace());
        }
    }

    private String getInfoText() {
        return "Testing connection" + (String)(this.globalElement != null && this.globalElement.getName() != null ? " with " + this.globalElement.getName() : "") + "...";
    }

    public MuleConfiguration getMuleConfiguration() {
        return this.muleConfiguration;
    }

    public MessageFlowNode getGlobalElement() {
        return this.globalElement;
    }

    public IMuleProject getMuleProject() {
        return this.muleProject;
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public void setInterrupted(boolean interrupted) {
        this.interrupted = interrupted;
    }

    private final class TestConnectionRunnable
    implements Runnable {
        private final IProgressMonitor progressMonitor;

        private TestConnectionRunnable(IProgressMonitor progressMonitor) {
            this.progressMonitor = progressMonitor;
        }

        @Override
        public void run() {
            this.progressMonitor.beginTask(TestConnectorConnectionFromMuleConfigAction.this.getInfoText(), -1);
            Supplier<IMessageFlowNode> newMessageFlowNodeSupplier = MessageFlowUtils.generateNodeToTestSupplier((IMessageFlowNode)TestConnectorConnectionFromMuleConfigAction.this.getGlobalElement());
            Function<IMessageFlowNode, PropertyCollectionMap> updatedPropertiesProvider = MessageFlowUtils.updatedPropertiesProvider(TestConnectorConnectionFromMuleConfigAction.this.contributedPages);
            try {
                TestConnectionExecutor testConnector = ((TestConnectionExecutor.TestConnectionExecutorBuilder)((TestConnectionExecutor.TestConnectionExecutorBuilder)((TestConnectionExecutor.TestConnectionExecutorBuilder)((TestConnectionExecutor.TestConnectionExecutorBuilder)((TestConnectionExecutor.TestConnectionExecutorBuilder)((TestConnectionExecutor.TestConnectionExecutorBuilder)((TestConnectionExecutor.TestConnectionExecutorBuilder)((TestConnectionExecutor.TestConnectionExecutorBuilder)new TestConnectionExecutor.TestConnectionExecutorBuilder().toolingWorkspace(ToolingWorkspace.getInstance())).muleInstance(ToolingManager.getInstance().getToolingInstance())).project(TestConnectorConnectionFromMuleConfigAction.this.muleProject)).muleConfiguration(TestConnectorConnectionFromMuleConfigAction.this.muleConfiguration)).generalErrorMessage(TestConnectorConnectionFromMuleConfigAction.TEST_CONN_GENERAL_ERROR_MESSAGE)).messageFlowNode((IMessageFlowNode)TestConnectorConnectionFromMuleConfigAction.this.getGlobalElement())).newMessageFlowNodeSupplier(newMessageFlowNodeSupplier)).updatedPropertiesProvider(updatedPropertiesProvider)).timeOutInMilliseconds(TestConnectorConnectionFromMuleConfigAction.this.getTimeoutInMilliseconds()).build();
                TestConnectorConnectionFromMuleConfigAction.this.connectionResult = testConnector.runServiceRequest();
            }
            catch (ToolingNotAvailableException e) {
                MuleCorePlugin.logError((String)TestConnectorConnectionFromMuleConfigAction.TEST_CONN_GENERAL_ERROR_MESSAGE, (Throwable)e);
                TestConnectorConnectionFromMuleConfigAction.this.connectionResult = ServiceResponseFactory.failure((Exception)((Object)e));
            }
        }
    }
}

