/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.action;

import java.util.Optional;
import org.eclipse.ui.IWorkbenchPart;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.module.MessageFlowNodeAction;
import org.mule.tooling.messageflow.util.GoToImplementationHandlerManager;
import org.mule.tooling.model.messageflow.IReadOnlyProperty;
import org.mule.tooling.model.messageflow.MessageFlowNode;

public class ShowFlowAction
extends MessageFlowNodeAction {
    public ShowFlowAction(IMuleProject project, MessageFlowNode node, IWorkbenchPart part) {
        super(project, node, part);
        this.setText("&Go to referenced flow\tF3");
    }

    protected boolean calculateEnabled() {
        IMuleProject muleProject = MuleCorePlugin.getDesignContext().getMuleProject();
        String referencedFlow = Optional.ofNullable((IReadOnlyProperty)this.getNode().getProperties().getProperty("name")).map(p -> p.getValue()).orElse("");
        return !referencedFlow.isBlank() && muleProject.getConfigurationsCache().searchMuleFlowByName(referencedFlow) != null;
    }

    public void run() {
        GoToImplementationHandlerManager gotoManager = GoToImplementationHandlerManager.INSTANCE;
        gotoManager.execute(this.getNode());
    }
}

