/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.action;

import java.util.Optional;
import org.eclipse.gef.ui.actions.WorkbenchPartAction;
import org.eclipse.ui.IWorkbenchPart;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.handler.ShowFlowHandler;
import org.mule.tooling.model.messageflow.IReadOnlyProperty;
import org.mule.tooling.model.messageflow.NestedContainer;

public class ShowErrorHandlerAction
extends WorkbenchPartAction {
    private NestedContainer nestedContainer;

    public ShowErrorHandlerAction(NestedContainer selectedEditPart, IWorkbenchPart part) {
        super(part);
        this.setText("&Go to referenced error handler\tF3");
        this.nestedContainer = selectedEditPart;
    }

    protected boolean calculateEnabled() {
        IMuleProject muleProject = MuleCorePlugin.getDesignContext().getMuleProject();
        String referencedErrorHandler = Optional.ofNullable((IReadOnlyProperty)this.nestedContainer.getProperties().getProperty("ref")).map(p -> p.getValue()).orElse("");
        return !referencedErrorHandler.isBlank() && muleProject.getConfigurationsCache().searchMuleFlowByName(referencedErrorHandler) != null;
    }

    public void run() {
        IReadOnlyProperty refProperty = (IReadOnlyProperty)this.nestedContainer.getProperties().getProperty("ref");
        String errorHandlerName = refProperty.getValue();
        ShowFlowHandler.goToFlowWithName(errorHandlerName);
    }
}

