/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.action;

import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;
import org.mule.tooling.core.ModelUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.module.MessageFlowNodeAction;
import org.mule.tooling.messageflow.outline.AbstractOutlinePopupDialog;
import org.mule.tooling.messageflow.referenced.ErrorHandlerReferencedByPopupDialog;
import org.mule.tooling.messageflow.referenced.FlowReferencedByPopupDialog;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.ui.MuleImages;

public class ReferencedByAction
extends MessageFlowNodeAction {
    private static final String REFERENCED_BY_COMMAND_ID = "org.mule.tooling.ui.referencedByCommand";

    public ReferencedByAction(IMuleProject project, MessageFlowNode node, IWorkbenchPart part) {
        super(project, node, part);
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        String keyBinding = bindingService.getBestActiveBindingFormattedFor(REFERENCED_BY_COMMAND_ID);
        StringBuilder stringBuilder = new StringBuilder("Referenced by");
        if (keyBinding != null) {
            stringBuilder.append(" (" + keyBinding + ")");
        }
        this.setText(stringBuilder.toString());
        this.setImageDescriptor(MuleImages.DESC_SEARCH_REF);
    }

    protected boolean calculateEnabled() {
        return ModelUtils.isFlowOrSubflow((IMessageFlowEntity)this.getNode()) || ModelUtils.isErrorHandler((IMessageFlowEntity)this.getNode());
    }

    public void run() {
        AbstractOutlinePopupDialog dialog = ModelUtils.isFlowOrSubflow((IMessageFlowEntity)this.getNode()) ? new FlowReferencedByPopupDialog(this.getNode().getName(), Display.getCurrent().getActiveShell()) : new ErrorHandlerReferencedByPopupDialog(this.getNode().getName(), Display.getCurrent().getActiveShell());
        dialog.open();
    }
}

