/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.action;

import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.mule.tooling.messageflow.util.MessageFlowUtils;

public class PasteAction
extends SelectionAction {
    private static final String PASTE_ACTION_LABEL = "Paste";

    public PasteAction(IWorkbenchPart editor) {
        super(editor);
    }

    protected boolean calculateEnabled() {
        return true;
    }

    protected Command createPasteCommand() {
        Object obj;
        Command result = null;
        List selection = this.getSelectedObjects();
        if (selection != null && selection.size() == 1 && (obj = selection.get(0)) instanceof GraphicalEditPart) {
            GraphicalEditPart gep = (GraphicalEditPart)obj;
            List editPartsToBePasted = (List)Clipboard.getDefault().getContents();
            if (editPartsToBePasted != null) {
                ChangeBoundsRequest changeBoundsRequest = new ChangeBoundsRequest((Object)"clone");
                changeBoundsRequest.setEditParts(editPartsToBePasted);
                changeBoundsRequest.setLocation(this.getPasteLocation(gep));
                EditPart targetEditPart = gep.getTargetEditPart((Request)changeBoundsRequest);
                if (targetEditPart != null) {
                    result = targetEditPart.getCommand((Request)changeBoundsRequest);
                }
            }
        }
        return result;
    }

    protected CreationFactory getFactory(Object template) {
        if (template instanceof CreationFactory) {
            return (CreationFactory)template;
        }
        return null;
    }

    protected Point getPasteLocation(GraphicalEditPart container) {
        return MessageFlowUtils.getCursorPosition();
    }

    protected void init() {
        this.setId(ActionFactory.PASTE.getId());
        this.setText(PASTE_ACTION_LABEL);
    }

    public void run() {
        this.execute(this.createPasteCommand());
    }
}

