/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.action;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.module.MessageFlowNodeAction;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.ui.MuleImages;

public class OpenClassAction
extends MessageFlowNodeAction {
    private String className;

    public OpenClassAction(IMuleProject muleProject, MessageFlowNode node, IWorkbenchPart part) {
        super(muleProject, node, part);
    }

    protected boolean calculateEnabled() {
        return this.className != null && this.className.length() > 0;
    }

    protected void init() {
        super.init();
        this.setText("Open Class");
        this.setDescription("Open a class in a Java editor.");
        this.setImageDescriptor(MuleImages.DESC_MULE_SMALL);
    }

    public void run() {
        if (this.className != null && this.className.length() > 0) {
            IJavaProject javaProject = this.getMuleProject().getJavaProject();
            try {
                IType type = javaProject.findType(this.className);
                if (type != null) {
                    try {
                        JavaUI.openInEditor((IJavaElement)type);
                    }
                    catch (PartInitException e) {
                        ErrorDialog.openError((Shell)this.getWorkbenchPart().getSite().getShell(), (String)"Error", (String)"Unable to open editor for class.", (IStatus)e.getStatus());
                    }
                }
            }
            catch (JavaModelException e) {
                ErrorDialog.openError((Shell)this.getWorkbenchPart().getSite().getShell(), (String)"Error", (String)"Unable to open class.", (IStatus)e.getStatus());
            }
        }
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }
}

