/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.action;

import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.mule.tooling.client.api.PropagationInfo;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.command.ExtractEntityToNewFlowNodeCommand;
import org.mule.tooling.messageflow.dialog.ExtractEntityToNewFlowDialog;
import org.mule.tooling.messageflow.module.MessageFlowNodeAction;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.metadata.custom.metadata.assistant.CustomMetadataAssistantService;
import org.mule.tooling.metadata.custom.metadata.assistant.MetadataActualExpectedParametersContainer;
import org.mule.tooling.metadata.datasense.DataSenseJob;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.module.ContainerDefinition;

public class ExtractEntityToFlowAction
extends MessageFlowNodeAction {
    private String flowName;
    private ContainerDefinition nodeDefinition;
    private CustomMetadataAssistantService customMetadataAssistantService;

    public ExtractEntityToFlowAction(IMuleProject project, IWorkbenchPart part, ContainerDefinition nodeDefinition) {
        super(project, null, (IWorkbenchPart)((IEditorPart)part));
        this.nodeDefinition = nodeDefinition;
        this.setText(nodeDefinition.getName());
        this.setId(nodeDefinition.getId());
        this.setImageDescriptor(nodeDefinition.getIcon());
        this.customMetadataAssistantService = (CustomMetadataAssistantService)project.getProjectComponent(CustomMetadataAssistantService.class);
    }

    public void run() {
        MuleConfiguration muleConfiguration = MessageFlowUtils.getMuleConfigFromActivePage();
        ExtractEntityToNewFlowDialog extractEntityToNewFlowDialog = new ExtractEntityToNewFlowDialog(Display.getCurrent().getActiveShell(), this.flowName, this.customMetadataAssistantService);
        int id = extractEntityToNewFlowDialog.open();
        this.setFlowName(extractEntityToNewFlowDialog.getFlowName());
        if (id == 0 && this.getFlowName() != null && !this.getFlowName().isEmpty()) {
            ExtractEntityToNewFlowNodeCommand extractCommand = new ExtractEntityToNewFlowNodeCommand(this.getMuleProject(), muleConfiguration, extractEntityToNewFlowDialog.getSelectedMuleConfiguration(), this.nodeDefinition);
            extractCommand.setFlowName(this.getFlowName());
            this.execute(extractCommand);
            IElementWrapper originFlowElement = extractCommand.getFlowRef().getElement();
            Container createdContainer = extractCommand.getCreatedContainer();
            if (extractEntityToNewFlowDialog.getAdvancedOptionsUsed()) {
                MetadataActualExpectedParametersContainer preferencesContainer = extractEntityToNewFlowDialog.getPropagationPreferences();
                PropagationInfo firstElement = extractEntityToNewFlowDialog.getPropagationJobs().getFirst().joinAndGetPropagationInfo();
                PropagationInfo lastElement = extractEntityToNewFlowDialog.getPropagationJobs().getLast().joinAndGetPropagationInfo();
                this.customMetadataAssistantService.translatePersistAndAssignMetadata(firstElement, lastElement, originFlowElement, preferencesContainer, (MessageFlowNode)createdContainer, false);
                AnalyticsRecordsFactory.single((String)Events.PROPAGATE_METADATA_EXTRACT_FLOW_ADVANCED, (IMuleProject)this.muleProject).track();
            } else {
                DataSenseJob firstElement = extractEntityToNewFlowDialog.getPropagationJobs().getFirst();
                DataSenseJob lastElement = extractEntityToNewFlowDialog.getPropagationJobs().getLast();
                this.customMetadataAssistantService.resolveTranslatePersistAndAssignMetadata(firstElement, lastElement, originFlowElement, (MessageFlowNode)createdContainer, false);
                AnalyticsRecordsFactory.single((String)Events.PROPAGATE_METADATA_EXTRACT_FLOW_BASIC, (IMuleProject)this.muleProject).track();
            }
        }
    }

    public void setFlowName(String flowName) {
        this.flowName = flowName;
    }

    public String getFlowName() {
        return this.flowName;
    }

    protected boolean calculateEnabled() {
        MuleConfiguration muleConfiguration = MessageFlowUtils.getMuleConfigFromActivePage();
        ExtractEntityToNewFlowNodeCommand extractCommand = new ExtractEntityToNewFlowNodeCommand(this.getMuleProject(), muleConfiguration, muleConfiguration, this.nodeDefinition);
        return extractCommand.canExecute();
    }
}

