/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.action;

import java.io.File;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.core.ModelUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.editor.MultiPageMessageFlowEditor;
import org.mule.tooling.messageflow.editpart.ContainerEditPart;
import org.mule.tooling.messageflow.module.MessageFlowNodeAction;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.ui.MuleImages;

public class ExportImageToFileAction
extends MessageFlowNodeAction {
    public ExportImageToFileAction(IMuleProject project, MessageFlowNode node, IWorkbenchPart part) {
        super(project, node, part);
        this.setText("Export flow image to file...");
        this.setImageDescriptor(MuleImages.DESC_EXPORT_IMAGE);
    }

    protected boolean calculateEnabled() {
        return ModelUtils.isFlowOrSubflow((IMessageFlowEntity)this.getNode());
    }

    public void run() {
        String fileSelected;
        IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        MultiPageMessageFlowEditor editor = (MultiPageMessageFlowEditor)activeEditor;
        MessageFlowEditor messageFlowEditor = editor.getFlowEditor();
        ContainerEditPart flowContainerEditPart = (ContainerEditPart)MessageFlowEditor.findEditPartInRegistry((EditPartViewer)messageFlowEditor.getViewer(), (IMessageFlowEntity)this.getNode());
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        FileDialog dialog = new FileDialog(shell, 8192);
        dialog.setFilterExtensions(new String[]{"png", "jpg", "bmp"});
        if (messageFlowEditor.getMuleProject() != null) {
            dialog.setFileName(this.getNode().getName());
        }
        if ((fileSelected = dialog.open()) != null) {
            boolean confirmation;
            File outputFile = new File(fileSelected);
            if (outputFile.exists() && !(confirmation = MessageDialog.openQuestion((Shell)dialog.getParent(), (String)"Confirmation", (String)(outputFile.getAbsolutePath() + " already exists.\nDo you want to overwrite it?")))) {
                return;
            }
            Image resultImage = MessageFlowUtils.getImageToExport(flowContainerEditPart);
            try {
                String resultedFile = this.removeFilterExtensions(fileSelected);
                this.writeImage(dialog, resultedFile, resultImage);
            }
            finally {
                resultImage.dispose();
            }
        }
    }

    private String removeFilterExtensions(String fileName) {
        String resultedFile = fileName;
        if (fileName.toLowerCase().endsWith(".png") || fileName.toLowerCase().endsWith(".jpg") || fileName.toLowerCase().endsWith(".bmp")) {
            resultedFile = fileName.substring(0, fileName.length() - 4);
        } else if (fileName.toLowerCase().endsWith("png") || fileName.toLowerCase().endsWith("jpg") || fileName.toLowerCase().endsWith("bmp")) {
            resultedFile = fileName.substring(0, fileName.length() - 3);
        }
        return resultedFile;
    }

    public void writeImage(FileDialog dialog, String fileSelected, Image resultImage) {
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{resultImage.getImageData()};
        switch (dialog.getFilterIndex()) {
            case 0: {
                loader.save(fileSelected + ".png", 5);
                break;
            }
            case 1: {
                loader.save(fileSelected + ".jpg", 4);
                break;
            }
            case 2: {
                loader.save(fileSelected + ".bmp", 0);
                break;
            }
            default: {
                loader.save(fileSelected + ".png", 5);
            }
        }
    }
}

