/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.event.CurrentEditorPartChangedEvent;
import org.mule.tooling.core.event.MuleProjectChangedEvent;
import org.mule.tooling.core.io.EditingScope;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.core.utils.ProjectStructureContributionManager;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.editor.MultiPageMessageFlowEditor;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.utils.eventbus.IEvent;

public class StudioDesignContextUpdaterListener
implements IPartListener2 {
    private static StudioDesignContextUpdaterListener instance;
    private IEditorPart visibleEditor;
    private boolean debug = false;

    public static void initialize() {
        if (instance == null) {
            instance = new StudioDesignContextUpdaterListener();
            IEditorPart currentEditor = StudioDesignContextUpdaterListener.getCurrentEditor();
            if (currentEditor != null) {
                instance.updateContext(currentEditor);
            }
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().addPartListener((IPartListener2)instance);
        }
    }

    private static IEditorPart getCurrentEditor() {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage == null) {
            return null;
        }
        IEditorPart activeEditor = activePage.getActiveEditor();
        if (activeEditor == null) {
            return null;
        }
        return activeEditor;
    }

    private void updateContext(IEditorPart editorPart) {
        IEditorInput editorInput = editorPart.getEditorInput();
        if (editorInput != null) {
            IResource editorInputAsResource = (IResource)editorInput.getAdapter(IResource.class);
            try {
                IProject project;
                if (editorInputAsResource != null && (CoreUtils.hasMuleNature((IProject)(project = editorInputAsResource.getProject())) || CoreUtils.hasSDKNature((IProject)project))) {
                    MultiPageMessageFlowEditor messageflowEditor;
                    IMuleProject muleProjectFromEditor;
                    IMuleProject muleProject = MuleRuntime.create((IProject)project);
                    if (muleProject != null) {
                        this.doUpdate(muleProject, editorInputAsResource);
                    } else if (editorPart instanceof MultiPageMessageFlowEditor && (muleProjectFromEditor = (messageflowEditor = (MultiPageMessageFlowEditor)editorPart).getOwnMuleProject()) != null) {
                        this.doUpdate(muleProjectFromEditor, editorInputAsResource);
                    }
                }
            }
            catch (CoreException e) {
                MuleCorePlugin.logError((String)("There was an error retrieving the muleProject from this editor part: " + String.valueOf(editorPart)), (Throwable)e);
            }
            MuleCorePlugin.getEventBus().fireEvent((IEvent)new CurrentEditorPartChangedEvent(editorPart));
        }
    }

    public void doUpdate(IMuleProject muleProject, IResource resource) {
        EditingScope scope = ProjectStructureContributionManager.getDefault().getScope(resource);
        this.doUpdate(muleProject, scope);
    }

    public void doUpdate(IMuleProject muleProject, EditingScope scope) {
        if (this.debug) {
            System.out.println("***** updateContext *****");
        }
        MuleCorePlugin.getDefaultDesignContext().updateContext(muleProject, scope);
        MuleCorePlugin.getEventBus().fireEvent((IEvent)new MuleProjectChangedEvent(muleProject));
    }

    private void clearContext() {
        if (this.debug) {
            System.out.println("***** clearContext *****");
        }
        MuleCorePlugin.getDefaultDesignContext().dispose();
        MuleCorePlugin.getEventBus().fireEvent((IEvent)new MuleProjectChangedEvent(null));
        MuleCorePlugin.getEventBus().fireEvent((IEvent)new CurrentEditorPartChangedEvent(null));
    }

    private IEditorPart getEditor(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (part instanceof IEditorPart) {
            IEditorPart editorPart = (IEditorPart)part;
            return editorPart;
        }
        return null;
    }

    public void partOpened(IWorkbenchPartReference partRef) {
        IEditorPart editorPart;
        if (this.debug) {
            System.out.println("***** partOpened " + partRef.getId() + " *****");
        }
        if ((editorPart = this.getEditor(partRef)) != null) {
            this.updateContext(editorPart);
        }
    }

    public void partClosed(IWorkbenchPartReference partRef) {
        IEditorPart editorPart;
        if (this.debug) {
            System.out.println("***** partClosed " + partRef.getId() + " *****");
        }
        if ((editorPart = this.getEditor(partRef)) != null && editorPart == this.visibleEditor) {
            this.clearContext();
        }
        this.visibleEditor = null;
        MessageFlowEditor flowEditorFromActivePage = MessageFlowUtils.getFlowEditorFromActivePage();
        if (flowEditorFromActivePage != null) {
            this.visibleEditor = flowEditorFromActivePage;
            this.updateContext((IEditorPart)flowEditorFromActivePage);
        }
    }

    public void partActivated(IWorkbenchPartReference partRef) {
        IEditorPart editorPart;
        if (this.debug) {
            System.out.println("***** partActivated " + partRef.getId() + " *****");
        }
        if ((editorPart = this.getEditor(partRef)) != null) {
            this.updateContext(editorPart);
        }
    }

    public void partVisible(IWorkbenchPartReference partRef) {
        IEditorPart editorPart;
        if (this.debug) {
            System.out.println("***** partVisible " + partRef.getId() + " *****");
        }
        if ((editorPart = this.getEditor(partRef)) != null) {
            this.visibleEditor = editorPart;
            this.updateContext(editorPart);
        }
    }

    public void partHidden(IWorkbenchPartReference partRef) {
        IEditorPart editorPart;
        if (this.debug) {
            System.out.println("***** partHidden " + partRef.getId() + " *****");
        }
        if ((editorPart = this.getEditor(partRef)) != null) {
            // empty if block
        }
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
        IEditorPart editorPart = this.getEditor(partRef);
        if (editorPart != null) {
            this.visibleEditor = editorPart;
            this.updateContext(editorPart);
        }
    }
}

