/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.core.JarEntryFile;
import org.eclipse.jdt.internal.ui.javaeditor.JarEntryEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorMatchingStrategy;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.mule.tooling.runtime.launch.XmlInput;
import org.mule.tooling.runtime.launch.XmlStorage;
import org.mule.tooling.utils.InMemoryConfigurationFile;

public class MultiPageMessageFlowEditorMatchingStrategy
implements IEditorMatchingStrategy {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean matches(IEditorReference editorRef, IEditorInput input) {
        try {
            IEditorInput editorInput = editorRef.getEditorInput();
            if (editorInput == null) {
                return false;
            }
            if (input instanceof JarEntryEditorInput) {
                IFile currentInputFile = (IFile)editorInput.getAdapter(IFile.class);
                if (currentInputFile == null && !(currentInputFile instanceof InMemoryConfigurationFile)) {
                    return false;
                }
                IStorage storage = ((JarEntryEditorInput)input).getStorage();
                if (!(storage instanceof JarEntryFile)) {
                    return false;
                }
                JarEntryFile jarEntryFile = (JarEntryFile)storage;
                IProject project = jarEntryFile.getPackageFragmentRoot().getJavaProject().getProject();
                return currentInputFile.getName().equals(jarEntryFile.getName()) && currentInputFile.getProject().equals((Object)project);
            }
            if (!(input instanceof IFileEditorInput)) {
                return false;
            }
            IFile inputFile = (IFile)input.getAdapter(IFile.class);
            if (inputFile == null) {
                return false;
            }
            if (editorInput instanceof XmlInput) {
                IStorage storage = ((XmlInput)editorInput).getStorage();
                if (storage instanceof XmlStorage) {
                    return inputFile.getFullPath().equals((Object)((XmlStorage)storage).getTempPath());
                }
                return inputFile.getFullPath().equals((Object)storage.getFullPath());
            }
            IFile currInputFile = (IFile)editorInput.getAdapter(IFile.class);
            if (currInputFile == null) {
                return false;
            }
            if (!inputFile.getProject().equals((Object)currInputFile.getProject())) {
                return false;
            }
            IPath fullPath = inputFile.getFullPath();
            IPath fullPath2 = currInputFile.getFullPath();
            return fullPath != null && fullPath.equals((Object)fullPath2);
        }
        catch (PartInitException partInitException) {
            return false;
        }
        catch (CoreException coreException) {
            return false;
        }
    }
}

