/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow;

import java.lang.reflect.Method;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.MoveProjectOperation;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.WorkbenchJob;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.messageflow.StudioDesignContextUpdaterListener;
import org.mule.tooling.messageflow.editor.MultiPageMessageFlowEditor;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.events.EditPartEventTypes;
import org.mule.tooling.messageflow.events.IEditPartSelectedEventListener;
import org.mule.tooling.messageflow.explorer.MulePackageExplorerContributor;
import org.mule.tooling.model.messageflow.CommentContainer;
import org.mule.tooling.model.messageflow.Compartment;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.EndpointNode;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.GlobalUnknown;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.PatternNode;
import org.mule.tooling.model.messageflow.Route;
import org.mule.tooling.model.messageflow.SplitterNode;
import org.mule.tooling.model.messageflow.UnknownNode;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitor;
import org.mule.tooling.ui.widgets.image.PluginImageRegistry;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.IEventHandler;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.mule.tooling.messageflow";
    public static final String EXT_POINT_XML_EDITOR = "org.mule.tooling.messageflow.xmlEditor";
    private static Activator plugin;
    private EventBusHelper helper = new EventBusHelper();
    private static PluginImageRegistry imageRegistry;

    public Activator() {
        EventBus eventBus = MuleCorePlugin.getEventBus();
        this.helper.registerListener(eventBus, EditPartEventTypes.ON_EDIT_PART_SELECTED, (IEventHandler)new IEditPartSelectedEventListener(){

            @Override
            public void onEditPartSelected(MuleConfiguration configuration, EntityEditPart<?> editPart) {
                IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (activeWorkbenchWindow == null) {
                    return;
                }
                IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
                if (activePage != null && activePage.getActiveEditor() instanceof MultiPageMessageFlowEditor) {
                    editPart.getEntity().accept((MessageFlowEntityVisitor)new TrackableEditPartVisitor(activePage));
                }
            }
        });
    }

    void scheduleRegisterListenerJob() {
        WorkbenchJob registerListenerJob = new WorkbenchJob("Register edit part listener"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                StudioDesignContextUpdaterListener.initialize();
                return Status.OK_STATUS;
            }
        };
        registerListenerJob.schedule();
    }

    public static PluginImageRegistry getImages() {
        if (imageRegistry == null) {
            imageRegistry = new PluginImageRegistry(Activator.getDefault().getBundle());
        }
        return imageRegistry;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.scheduleRegisterListenerJob();
        WorkbenchJob workbenchJob = new WorkbenchJob("Register project move listener"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IOperationHistory operationHistory = PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
                operationHistory.addOperationHistoryListener((IOperationHistoryListener)new ProjectMoveListener());
                new MulePackageExplorerContributor().init();
                return Status.OK_STATUS;
            }
        };
        workbenchJob.schedule();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        this.helper.unregister();
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static IStatus createStatus(int type, String message, Throwable e) {
        return new Status(type, PLUGIN_ID, message, e);
    }

    public static IStatus createStatus(int type, String message) {
        return new Status(type, PLUGIN_ID, message);
    }

    public static void openError(Shell shell, Exception e) {
        ErrorDialog.openError((Shell)shell, (String)"Error", (String)e.getMessage(), (IStatus)Activator.createStatus(4, e.getMessage()));
    }

    private static final class ProjectMoveListener
    implements IOperationHistoryListener {
        private ProjectMoveListener() {
        }

        public void historyNotification(OperationHistoryEvent event) {
            IUndoableOperation operation = event.getOperation();
            if (event.getEventType() == 1 && operation instanceof MoveProjectOperation) {
                try {
                    Method declaredMethod = operation.getClass().getDeclaredMethod("getProject", new Class[0]);
                    declaredMethod.setAccessible(true);
                    final IProject project = (IProject)declaredMethod.invoke((Object)operation, new Object[0]);
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            MultiPageMessageFlowEditor.OpenEditors openEditors = MultiPageMessageFlowEditor.selectOpenEditorsOfProject(project.getName());
                            for (MultiPageMessageFlowEditor ed : openEditors.editorsInFlowMode) {
                                ed.close(false);
                            }
                            for (MultiPageMessageFlowEditor ed : openEditors.editorsInXmlMode) {
                                ed.close(false);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class TrackableEditPartVisitor
    implements MessageFlowEntityVisitor {
        private IWorkbenchPage activePage;
        private MultiPageMessageFlowEditor activeEditor;

        public TrackableEditPartVisitor(IWorkbenchPage activePage) {
            this.activePage = activePage;
            this.activeEditor = (MultiPageMessageFlowEditor)activePage.getActiveEditor();
        }

        public void visitMuleConfiguration(MuleConfiguration muleConfiguration) {
        }

        public void visitGlobalElement(GlobalElement globalElement) {
        }

        public void visitContainer(Container container) {
            this.track();
        }

        public void visitNestedContainer(NestedContainer nestedContainer) {
        }

        public void visitCompartment(Compartment compartment) {
        }

        public void visitCompartmentLane(CompartmentLane lane) {
        }

        public void visitEndpointNode(EndpointNode endpointNode) {
            this.track();
        }

        public void visitPatternNode(PatternNode patternNode) {
            this.track();
        }

        public void visitSplitterNode(SplitterNode splitterNode) {
            this.track();
        }

        public void visitGlobalUnknown(GlobalUnknown globalUnknown) {
        }

        public void visitUnknownNode(UnknownNode unknownNode) {
            this.track();
        }

        public void visitCommentNode(CommentContainer commentNode) {
            this.track();
        }

        public void visitRoute(Route route) {
        }

        private void track() {
            this.activePage.getNavigationHistory().markLocation((IEditorPart)this.activeEditor.getFlowEditor());
        }
    }
}

