/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.ecore.EObject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.dfl.dFL.Attribute;
import org.mule.tooling.dfl.dFL.Body;
import org.mule.tooling.dfl.dFL.BooleanLiteral;
import org.mule.tooling.dfl.dFL.Content;
import org.mule.tooling.dfl.dFL.DFLFactory;
import org.mule.tooling.dfl.dFL.DeclaredNamespace;
import org.mule.tooling.dfl.dFL.Directive;
import org.mule.tooling.dfl.dFL.Document;
import org.mule.tooling.dfl.dFL.Expression;
import org.mule.tooling.dfl.dFL.FunctionDirective;
import org.mule.tooling.dfl.dFL.Header;
import org.mule.tooling.dfl.dFL.ImportDirective;
import org.mule.tooling.dfl.dFL.ImportModuleOnly;
import org.mule.tooling.dfl.dFL.ImportWithSubElements;
import org.mule.tooling.dfl.dFL.InputDirective;
import org.mule.tooling.dfl.dFL.IntegerLiteral;
import org.mule.tooling.dfl.dFL.Key;
import org.mule.tooling.dfl.dFL.NamespaceDirective;
import org.mule.tooling.dfl.dFL.OutputDirective;
import org.mule.tooling.dfl.dFL.QuotedStringLiteral;
import org.mule.tooling.dfl.dFL.StringLiteral;
import org.mule.tooling.dfl.dFL.TypeDirective;
import org.mule.tooling.dfl.dFL.VariableDirective;
import org.mule.tooling.dfl.parser.antlr.lexer.InternalDFLLexer;

public final class DFLModelHelper {
    private static final String QUOTATION_CHARACTER = "\"";
    private static final String SPECIAL_CHARACTERS = "\"'!#$()*+,-./:<=>?[]{}|%^@_&`~ ";
    private static final Pattern QUOTATION_PATTERN = Pattern.compile("^[^(0-9|!|#|$|(|)|*|+|,|\\-|.|/|:|<|=|>|?|\\[|\\]|{|}|\\||%|^|@|_|&| )][^(!|#|$|(|)|*|,|\\-|.|:|<|=|>|?|\\[|\\]|{|}|\\||%|^|\t| )]*");
    private static final Pattern VARIABLE_COUNTER_GROUP_PATTERN = Pattern.compile("^(?<Variable>.*?)(?<Counter>\\d+)$");

    private DFLModelHelper() {
    }

    private static List<Directive> getDirectives(Document document) {
        Header header;
        Body body = document.getBody();
        if (body != null && (header = body.getHeader()) != null) {
            return header.getDirectives();
        }
        return Collections.emptyList();
    }

    public static List<InputDirective> getInputDirectives(Document document) {
        return CoreUtils.filterByType(DFLModelHelper.getDirectives(document), InputDirective.class);
    }

    public static List<TypeDirective> getTypeDirectives(Document document) {
        return CoreUtils.filterByType(DFLModelHelper.getDirectives(document), TypeDirective.class);
    }

    public static List<NamespaceDirective> getNamespaceDirectives(Document document) {
        return CoreUtils.filterByType(DFLModelHelper.getDirectives(document), NamespaceDirective.class);
    }

    public static Document getRootDocument(EObject model) {
        if (model == null) {
            return DFLFactory.eINSTANCE.createDocument();
        }
        if (model instanceof Document) {
            return (Document)model;
        }
        return DFLModelHelper.getRootDocument(model.eContainer());
    }

    public static Optional<OutputDirective> getLastOutputDirective(Document document) {
        List outputDirectives = CoreUtils.filterByType(DFLModelHelper.getDirectives(document), OutputDirective.class);
        OutputDirective result = null;
        Iterator iterator = outputDirectives.iterator();
        while (iterator.hasNext()) {
            OutputDirective directive;
            result = directive = (OutputDirective)iterator.next();
        }
        return Optional.ofNullable(result);
    }

    public static Optional<EObject> getBodyContentExpression(Document document) {
        Expression element;
        Content content;
        Expression result = null;
        Body body = document.getBody();
        if (body != null && (content = body.getContent()) != null && (element = content.getElement()) != null) {
            result = element;
        }
        return Optional.ofNullable(result);
    }

    public static Object getLiteralValue(Expression expression) {
        if (expression instanceof QuotedStringLiteral) {
            return DFLModelHelper.removeQuotes(((QuotedStringLiteral)expression).getValue());
        }
        if (expression instanceof BooleanLiteral) {
            return ((BooleanLiteral)expression).isValue();
        }
        if (expression instanceof IntegerLiteral) {
            return ((IntegerLiteral)expression).getValue();
        }
        return null;
    }

    public static List<VariableDirective> getVarDirectives(Document document) {
        return CoreUtils.filterByType(DFLModelHelper.getDirectives(document), VariableDirective.class);
    }

    public static List<FunctionDirective> getFunctionDirectives(Document document) {
        return CoreUtils.filterByType(DFLModelHelper.getDirectives(document), FunctionDirective.class);
    }

    public static List<ImportModuleOnly> getImportsModuleOnly(Document document) {
        return CoreUtils.filterByType(DFLModelHelper.getDirectives(document), ImportModuleOnly.class);
    }

    public static List<ImportDirective> getImportDirectives(Document document) {
        return CoreUtils.filterByType(DFLModelHelper.getDirectives(document), ImportDirective.class);
    }

    public static List<ImportWithSubElements> getImportsWithSubElements(Document document) {
        return CoreUtils.filterByType(DFLModelHelper.getDirectives(document), ImportWithSubElements.class);
    }

    public static Optional<NamespaceDirective> getNamespaceDeclarationByPrefix(Document document, String prefix) {
        return DFLModelHelper.getNamespaceDirectives(document).stream().filter(new PredicateNamespaceByPrefix(prefix)).findFirst();
    }

    public static Optional<NamespaceDirective> getNamespaceDeclarationByUri(Document document, String uri) {
        return DFLModelHelper.getNamespaceDirectives(document).stream().filter(new PredicateNamespaceByUri(uri)).findFirst();
    }

    public static QName toQName(Key key) {
        Optional<NamespaceDirective> nameSpaceDeclaration;
        String prefix = "";
        String localPart = "";
        String namespaceURI = "";
        DeclaredNamespace namespace = key.getNamespace();
        if (namespace != null) {
            prefix = namespace.getName();
        }
        if ((nameSpaceDeclaration = DFLModelHelper.getNamespaceDeclarationByPrefix(DFLModelHelper.getRootDocument(key), prefix)).isPresent()) {
            namespaceURI = nameSpaceDeclaration.get().getValue();
        }
        if (key.getValue() instanceof StringLiteral) {
            StringLiteral literal = (StringLiteral)key.getValue();
            localPart = DFLModelHelper.removeQuotes(literal.getValue().trim());
        }
        return new QName(namespaceURI, localPart, prefix);
    }

    public static QName toQName(DeclaredNamespace namespace, String keyName) {
        keyName = DFLModelHelper.removeQuotes(keyName);
        if (namespace != null && StringUtils.isNotEmpty((String)namespace.getName())) {
            String prefix = namespace.getName();
            Optional<NamespaceDirective> nameSpaceDeclaration = DFLModelHelper.getNamespaceDeclarationByPrefix(DFLModelHelper.getRootDocument(namespace), prefix);
            if (nameSpaceDeclaration.isPresent()) {
                return new QName(nameSpaceDeclaration.get().getValue(), keyName, prefix);
            }
            return new QName("unknown", keyName, prefix);
        }
        return new QName(keyName);
    }

    public static void assignNamespace(Key key, QName qName) {
        if (StringUtils.isNotBlank((String)qName.getPrefix())) {
            DeclaredNamespace namespace = DFLFactory.eINSTANCE.createDeclaredNamespace();
            namespace.setName(qName.getPrefix());
            key.setNamespace(namespace);
        }
    }

    public static void assignNamespace(Attribute attribute, QName qName) {
        if (StringUtils.isNotBlank((String)qName.getPrefix())) {
            DeclaredNamespace namespace = DFLFactory.eINSTANCE.createDeclaredNamespace();
            namespace.setName(qName.getPrefix());
            attribute.setNamespace(namespace);
        }
    }

    public static String quoteIfNecessary(String data) {
        if (DFLModelHelper.requiresQuotes((String)data)) {
            data = QUOTATION_CHARACTER + (String)data + QUOTATION_CHARACTER;
        }
        return data;
    }

    public static String removeSpecialCharacters(String data) {
        if (StringUtils.containsAny((String)data, (String)SPECIAL_CHARACTERS)) {
            char[] cArray = SPECIAL_CHARACTERS.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char character = cArray[n2];
                data = data.replace(String.valueOf(character), "");
                ++n2;
            }
        }
        return data;
    }

    public static String removeQuotes(String data) {
        boolean isDoubleQuoted;
        boolean isSingleQuoted = data.startsWith("'") && data.endsWith("'");
        boolean bl = isDoubleQuoted = data.startsWith(QUOTATION_CHARACTER) && data.endsWith(QUOTATION_CHARACTER);
        if (isSingleQuoted || isDoubleQuoted) {
            data = data.substring(1, data.length() - 1);
        }
        return data;
    }

    public static boolean requiresQuotes(String str) {
        Matcher matcher = QUOTATION_PATTERN.matcher(str);
        return !matcher.matches() || InternalDFLLexer.KEYWORDS.contains(str);
    }

    public static String verifyName(List<String> existingNames, String newName) {
        Collections.sort(existingNames);
        if (existingNames.contains(newName)) {
            Optional<Object> variableMatcher = Optional.empty();
            for (String name : existingNames) {
                Matcher matcher = VARIABLE_COUNTER_GROUP_PATTERN.matcher(name);
                if (!matcher.matches()) continue;
                variableMatcher = Optional.of(matcher);
            }
            if (variableMatcher.isPresent()) {
                String name;
                name = ((Matcher)variableMatcher.get()).group("Variable");
                String counterArea = ((Matcher)variableMatcher.get()).group("Counter");
                Integer counter = Integer.valueOf(counterArea);
                Object[] objectArray = new Object[1];
                counter = counter + 1;
                objectArray[0] = counter;
                counterArea = String.format("%02d", objectArray);
                newName = name + counterArea;
            } else {
                newName = (String)newName + "01";
            }
        }
        return newName;
    }

    private static final class PredicateNamespaceByPrefix
    implements Predicate<NamespaceDirective> {
        private String prefix;

        public PredicateNamespaceByPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public boolean test(NamespaceDirective input) {
            return this.prefix.equals(input.getName());
        }
    }

    private static final class PredicateNamespaceByUri
    implements Predicate<NamespaceDirective> {
        private String uri;

        public PredicateNamespaceByUri(String uri) {
            this.uri = uri;
        }

        @Override
        public boolean test(NamespaceDirective input) {
            return this.uri.equals(input.getValue());
        }
    }
}

