/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.formatting;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatter;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatting;
import org.eclipse.xtext.formatting2.ITextReplacer;
import org.eclipse.xtext.formatting2.internal.HiddenRegionReplacer;
import org.eclipse.xtext.formatting2.regionaccess.HiddenRegionPartAssociation;
import org.eclipse.xtext.formatting2.regionaccess.IComment;
import org.eclipse.xtext.formatting2.regionaccess.IEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegionPart;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.formatting2.regionaccess.IWhitespace;
import org.eclipse.xtext.formatting2.regionaccess.internal.TextSegment;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.mule.tooling.dfl.dFL.And;
import org.mule.tooling.dfl.dFL.Array;
import org.mule.tooling.dfl.dFL.Attribute;
import org.mule.tooling.dfl.dFL.Attributes;
import org.mule.tooling.dfl.dFL.BinaryFunction;
import org.mule.tooling.dfl.dFL.Content;
import org.mule.tooling.dfl.dFL.DeclaredNamespace;
import org.mule.tooling.dfl.dFL.Directive;
import org.mule.tooling.dfl.dFL.DotSelector;
import org.mule.tooling.dfl.dFL.DynamicSelector;
import org.mule.tooling.dfl.dFL.EnclosedExpression;
import org.mule.tooling.dfl.dFL.EnclosedObjectElement;
import org.mule.tooling.dfl.dFL.Expression;
import org.mule.tooling.dfl.dFL.Header;
import org.mule.tooling.dfl.dFL.HeaderSeparator;
import org.mule.tooling.dfl.dFL.If;
import org.mule.tooling.dfl.dFL.KeyValuePair;
import org.mule.tooling.dfl.dFL.ObjectElements;
import org.mule.tooling.dfl.dFL.OptionElement;
import org.mule.tooling.dfl.dFL.Or;
import org.mule.tooling.dfl.dFL.Plus;
import org.mule.tooling.dfl.dFL.Unless;
import org.mule.tooling.dfl.dFL.Using;
import org.mule.tooling.dfl.dFL.Variable;
import org.mule.tooling.dfl.dFL.VariableDefinition;
import org.mule.tooling.dfl.dFL.util.DFLSwitch;

public class DFLFormatter2
extends AbstractFormatter2 {
    private static final Procedures.Procedure1<? super IHiddenRegionFormatter> SPACE = new Procedures.Procedure1<IHiddenRegionFormatter>(){

        public void apply(IHiddenRegionFormatter regionFormatter) {
            regionFormatter.oneSpace();
        }
    };
    private static final Procedures.Procedure1<? super IHiddenRegionFormatter> NEW_LINE = new Procedures.Procedure1<IHiddenRegionFormatter>(){

        public void apply(IHiddenRegionFormatter regionFormatter) {
            regionFormatter.newLine();
        }
    };
    private static final Procedures.Procedure1<? super IHiddenRegionFormatter> NO_SPACE = new Procedures.Procedure1<IHiddenRegionFormatter>(){

        public void apply(IHiddenRegionFormatter regionFormatter) {
            regionFormatter.noSpace();
        }
    };
    private static final Procedures.Procedure1<? super IHiddenRegionFormatter> NEW_LINE_AND_INCREASE_IDENTATION = new Procedures.Procedure1<IHiddenRegionFormatter>(){

        public void apply(IHiddenRegionFormatter regionFormatter) {
            regionFormatter.newLine();
            regionFormatter.indent();
        }
    };

    public ITextReplacer createHiddenRegionReplacer(IHiddenRegion region, IHiddenRegionFormatting formatting) {
        return new DFLHiddenRegionReplacer(region, formatting);
    }

    public void format(Object obj, IFormattableDocument document) {
        FormatterSwitch switcher = new FormatterSwitch(this, document);
        TreeIterator iter = EcoreUtil.getAllContents((Resource)((XtextResource)obj), (boolean)true);
        while (iter.hasNext()) {
            EObject current = (EObject)iter.next();
            switcher.doSwitch(current);
        }
    }

    private static final class DFLHiddenRegionReplacer
    extends HiddenRegionReplacer {
        public DFLHiddenRegionReplacer(IHiddenRegion region, IHiddenRegionFormatting formatting) {
            super(region, formatting);
        }

        protected List<ITextReplacer> createReplacers(AbstractFormatter2 formatter) {
            ITextSegment last;
            ArrayList<ITextSegment> segments = new ArrayList<ITextSegment>();
            List parts = this.getRegion().getParts();
            ArrayList result = Lists.newArrayList();
            for (IHiddenRegionPart part : parts) {
                ITextSegment last2;
                if (part instanceof IWhitespace) {
                    ITextSegment iTextSegment = last2 = !segments.isEmpty() ? (ITextSegment)segments.get(segments.size() - 1) : null;
                    if (last2 == null || last2 instanceof IComment) {
                        result.add(formatter.createWhitespaceReplacer((ITextSegment)part, formatter.createHiddenRegionFormatting()));
                        segments.add((ITextSegment)part);
                    } else if (!this.isPenultimateAComment(segments) || this.isPenultimateACommentWithAssociation(segments, HiddenRegionPartAssociation.NEXT)) {
                        int mergedLength = last2.getLength() + part.getLength();
                        TextSegment merged = new TextSegment(part.getTextRegionAccess(), last2.getOffset(), mergedLength);
                        IHiddenRegionFormatting formatting2 = formatter.createHiddenRegionFormatting();
                        result.set(result.size() - 1, formatter.createWhitespaceReplacer((ITextSegment)merged, formatting2));
                        segments.add((ITextSegment)merged);
                    } else if (this.isPenultimateACommentWithAssociation(segments, HiddenRegionPartAssociation.PREVIOUS)) {
                        result.remove(result.size() - 1);
                        segments.remove(segments.size() - 1);
                    }
                }
                if (!(part instanceof IComment)) continue;
                ITextSegment iTextSegment = last2 = !segments.isEmpty() ? (ITextSegment)segments.get(segments.size() - 1) : null;
                if (last2 == null || last2 instanceof IComment) {
                    TextSegment region = new TextSegment(part.getTextRegionAccess(), part.getOffset(), 0);
                    result.add(formatter.createWhitespaceReplacer((ITextSegment)region, formatter.createHiddenRegionFormatting()));
                }
                result.add(formatter.createCommentReplacer((IComment)part));
                segments.add((ITextSegment)part);
            }
            ITextSegment iTextSegment = last = !segments.isEmpty() ? (ITextSegment)segments.get(segments.size() - 1) : null;
            if (last instanceof IComment) {
                TextSegment region = new TextSegment(last.getTextRegionAccess(), last.getOffset() + last.getLength(), 0);
                result.add(formatter.createWhitespaceReplacer((ITextSegment)region, formatter.createHiddenRegionFormatting()));
            }
            return result;
        }

        private boolean isPenultimateACommentWithAssociation(List<ITextSegment> segments, HiddenRegionPartAssociation association) {
            return this.isPenultimateAComment(segments) && ((IComment)segments.get(segments.size() - 2)).getAssociation().compareTo((Enum)association) == 0;
        }

        private boolean isPenultimateAComment(List<ITextSegment> segments) {
            return segments.size() >= 2 && segments.get(segments.size() - 2) instanceof IComment;
        }
    }

    private static final class FormatterSwitch
    extends DFLSwitch<Void> {
        private ITextRegionAccess regionAccess;
        private IFormattableDocument formattableDocument;

        public FormatterSwitch(DFLFormatter2 formatter, IFormattableDocument formattableDocument) {
            this.regionAccess = formatter.getTextRegionAccess();
            this.formattableDocument = formattableDocument;
        }

        @Override
        public Void caseDirective(Directive object) {
            this.formattableDocument.append((EObject)object, NEW_LINE);
            return (Void)super.caseDirective(object);
        }

        @Override
        public Void caseHeader(Header object) {
            this.formattableDocument.append((EObject)object, NEW_LINE);
            return (Void)super.caseHeader(object);
        }

        @Override
        public Void caseContent(Content object) {
            this.formattableDocument.prepend((EObject)object, NEW_LINE);
            return (Void)super.caseContent(object);
        }

        @Override
        public Void caseHeaderSeparator(HeaderSeparator object) {
            this.formattableDocument.prepend((EObject)object, NEW_LINE);
            this.formattableDocument.append((EObject)object, NEW_LINE);
            return (Void)super.caseHeaderSeparator(object);
        }

        @Override
        public Void defaultCase(EObject object) {
            IEObjectRegion regionForEObject = this.regionAccess.regionForEObject(object);
            if (regionForEObject != null) {
                ISemanticRegion open = regionForEObject.getRegionFor().keyword("{");
                ISemanticRegion close = regionForEObject.getRegionFor().keyword("}");
                if (open != null && close != null) {
                    this.formattableDocument.interior(open, close, NEW_LINE_AND_INCREASE_IDENTATION);
                }
            }
            return (Void)super.defaultCase(object);
        }

        @Override
        public Void caseObjectElements(ObjectElements object) {
            IEObjectRegion regionForEObject = this.regionAccess.regionForEObject((EObject)object);
            if (regionForEObject != null) {
                List semanticRegions = regionForEObject.getRegionFor().keywords(new String[]{","});
                for (ISemanticRegion currentSemanticRegion : semanticRegions) {
                    this.formattableDocument.prepend(currentSemanticRegion, NO_SPACE);
                    this.formattableDocument.append(currentSemanticRegion, NEW_LINE);
                }
            }
            return (Void)super.caseObjectElements(object);
        }

        @Override
        public Void caseBinaryFunction(BinaryFunction object) {
            Variable functionName = object.getFunctionName();
            this.formattableDocument.prepend((EObject)functionName, SPACE);
            return (Void)super.caseBinaryFunction(object);
        }

        @Override
        public Void caseAnd(And object) {
            IEObjectRegion regionForEObject = this.regionAccess.regionForEObject((EObject)object);
            if (regionForEObject != null) {
                List semanticRegions = regionForEObject.getRegionFor().keywords(new String[]{"and"});
                for (ISemanticRegion currentSemanticRegion : semanticRegions) {
                    this.formattableDocument.prepend(currentSemanticRegion, SPACE);
                }
            }
            return (Void)super.caseAnd(object);
        }

        @Override
        public Void caseOr(Or object) {
            IEObjectRegion regionForEObject = this.regionAccess.regionForEObject((EObject)object);
            if (regionForEObject != null) {
                List semanticRegions = regionForEObject.getRegionFor().keywords(new String[]{"or"});
                for (ISemanticRegion currentSemanticRegion : semanticRegions) {
                    this.formattableDocument.prepend(currentSemanticRegion, SPACE);
                }
            }
            return (Void)super.caseOr(object);
        }

        @Override
        public Void casePlus(Plus object) {
            IEObjectRegion regionForEObject = this.regionAccess.regionForEObject((EObject)object);
            if (regionForEObject != null) {
                List semanticRegions = regionForEObject.getRegionFor().keywords(new String[]{"+"});
                for (ISemanticRegion currentSemanticRegion : semanticRegions) {
                    this.formattableDocument.prepend(currentSemanticRegion, SPACE);
                }
            }
            return (Void)super.casePlus(object);
        }

        @Override
        public Void caseEnclosedExpression(EnclosedExpression object) {
            Expression expression = object.getExpression();
            this.formattableDocument.prepend((EObject)expression, NO_SPACE);
            this.formattableDocument.append((EObject)expression, NO_SPACE);
            return (Void)super.caseEnclosedExpression(object);
        }

        @Override
        public Void caseEnclosedObjectElement(EnclosedObjectElement object) {
            IEObjectRegion regionForEObject = this.regionAccess.regionForEObject((EObject)object);
            if (regionForEObject != null) {
                ISemanticRegion open = regionForEObject.getRegionFor().keyword("(");
                ISemanticRegion close = regionForEObject.getRegionFor().keyword(")");
                this.formattableDocument.append(open, NO_SPACE);
                this.formattableDocument.prepend(close, NO_SPACE);
            }
            return (Void)super.caseEnclosedObjectElement(object);
        }

        @Override
        public Void caseUsing(Using object) {
            this.spaceParenthesis(object);
            return (Void)super.caseUsing(object);
        }

        @Override
        public Void caseIf(If object) {
            this.spaceParenthesis(object);
            return (Void)super.caseIf(object);
        }

        @Override
        public Void caseUnless(Unless object) {
            this.spaceParenthesis(object);
            return (Void)super.caseUnless(object);
        }

        private void spaceParenthesis(EObject object) {
            IEObjectRegion regionForEObject = this.regionAccess.regionForEObject(object);
            if (regionForEObject != null) {
                ISemanticRegion open = regionForEObject.getRegionFor().keyword("(");
                ISemanticRegion close = regionForEObject.getRegionFor().keyword(")");
                this.formattableDocument.surround(open, SPACE);
                this.formattableDocument.surround(close, SPACE);
            }
        }

        @Override
        public Void caseKeyValuePair(KeyValuePair object) {
            IEObjectRegion regionForEObject = this.regionAccess.regionForEObject((EObject)object);
            if (regionForEObject != null) {
                ISemanticRegion semanticRegion = regionForEObject.getRegionFor().keyword(":");
                this.formattableDocument.prepend(semanticRegion, NO_SPACE);
                this.formattableDocument.append(semanticRegion, SPACE);
            }
            return (Void)super.caseKeyValuePair(object);
        }

        @Override
        public Void caseAttributes(Attributes object) {
            IEObjectRegion regionForEObject = this.regionAccess.regionForEObject((EObject)object);
            if (regionForEObject != null) {
                ISemanticRegion open = regionForEObject.getRegionFor().keyword("@(");
                ISemanticRegion close = regionForEObject.getRegionFor().keyword(")");
                this.formattableDocument.append(open, NO_SPACE);
                this.formattableDocument.prepend(close, NO_SPACE);
            }
            return (Void)super.caseAttributes(object);
        }

        @Override
        public Void caseAttribute(Attribute object) {
            IEObjectRegion regionForEObject = this.regionAccess.regionForEObject((EObject)object);
            if (regionForEObject != null) {
                ISemanticRegion semanticRegion = regionForEObject.getRegionFor().keyword(":");
                this.formattableDocument.prepend(semanticRegion, NO_SPACE);
                this.formattableDocument.append(semanticRegion, SPACE);
            }
            return (Void)super.caseAttribute(object);
        }

        @Override
        public Void caseDeclaredNamespace(DeclaredNamespace object) {
            IEObjectRegion regionForEObject = this.regionAccess.regionForEObject((EObject)object);
            if (regionForEObject != null) {
                ISemanticRegion semanticRegion = regionForEObject.getRegionFor().keyword("#");
                this.formattableDocument.surround(semanticRegion, NO_SPACE);
            }
            return (Void)super.caseDeclaredNamespace(object);
        }

        @Override
        public Void caseDotSelector(DotSelector object) {
            IEObjectRegion regionForEObject = this.regionAccess.regionForEObject((EObject)object);
            if (regionForEObject != null) {
                List dot = regionForEObject.getRegionFor().keywords(new String[]{".", ".*", ".@", ".^", ".&", ".#"});
                for (ISemanticRegion iSemanticRegion : dot) {
                    this.formattableDocument.surround(iSemanticRegion, NO_SPACE);
                }
            }
            return (Void)super.caseDotSelector(object);
        }

        @Override
        public Void caseDynamicSelector(DynamicSelector object) {
            IEObjectRegion regionForEObject = this.regionAccess.regionForEObject((EObject)object);
            if (regionForEObject != null) {
                List regions = regionForEObject.getRegionFor().keywords(new String[]{"[*", "[@", "[^", "[&", "["});
                for (ISemanticRegion iSemanticRegion : regions) {
                    this.formattableDocument.surround(iSemanticRegion, NO_SPACE);
                }
                ISemanticRegion region = regionForEObject.getRegionFor().keyword("]");
                this.formattableDocument.prepend(region, NO_SPACE);
            }
            return (Void)super.caseDynamicSelector(object);
        }

        @Override
        public Void caseOptionElement(OptionElement object) {
            this.spaceEqual(object);
            return (Void)super.caseOptionElement(object);
        }

        @Override
        public Void caseVariableDefinition(VariableDefinition object) {
            this.spaceEqual(object);
            return (Void)super.caseVariableDefinition(object);
        }

        private void spaceEqual(EObject object) {
            IEObjectRegion regionForEObject = this.regionAccess.regionForEObject(object);
            if (regionForEObject != null) {
                ISemanticRegion equal = regionForEObject.getRegionFor().keyword("=");
                this.formattableDocument.surround(equal, SPACE);
            }
        }

        @Override
        public Void caseArray(Array object) {
            IEObjectRegion regionForEObject = this.regionAccess.regionForEObject((EObject)object);
            if (regionForEObject != null) {
                ISemanticRegion open = regionForEObject.getRegionFor().keyword("[");
                ISemanticRegion close = regionForEObject.getRegionFor().keyword("]");
                this.formattableDocument.append(open, NO_SPACE);
                this.formattableDocument.prepend(close, NO_SPACE);
            }
            return (Void)super.caseArray(object);
        }
    }
}

