/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.handlers.internal.buffer.impl;

import com.google.common.collect.Lists;
import com.mulesoft.agent.buffer.Buffer;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class MemoryBuffer<T extends Serializable>
implements Buffer<T> {
    private List<T> bufferElements = Collections.synchronizedList(Lists.newLinkedList());

    public void clean() {
        this.bufferElements.clear();
    }

    public void push(T t) {
        this.bufferElements.add(t);
    }

    public void pushAll(Collection<T> collection) {
        this.bufferElements.addAll(collection);
    }

    public Collection<T> get() {
        LinkedList collection = Lists.newLinkedList(this.bufferElements);
        this.clean();
        return collection;
    }

    public long getSize() {
        return this.bufferElements.size();
    }
}

