/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.handlers.internal.buffer.impl;

import com.mulesoft.agent.buffer.Buffer;
import com.mulesoft.agent.buffer.BufferConfiguration;
import com.mulesoft.agent.buffer.exception.BufferException;
import com.mulesoft.agent.handlers.internal.buffer.impl.BigQueuePersistentQueue;
import com.mulesoft.agent.handlers.internal.buffer.impl.PersistentQueue;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DiskBuffer<T extends Serializable>
implements Buffer<T> {
    private static final Logger LOGGER = LogManager.getLogger(DiskBuffer.class);
    private static final String DEFAULT_FILE_NAME = "buffer-" + UUID.randomUUID();
    private BigQueuePersistentQueue<T> queue;
    private File bufferFile;
    private BufferConfiguration bufferConfiguration;

    public DiskBuffer(BufferConfiguration bufferConfiguration) throws BufferException {
        this.bufferConfiguration = bufferConfiguration;
        if (this.queue == null || this.bufferFile == null) {
            if (bufferConfiguration.getFilePath() != null) {
                this.bufferFile = new File(bufferConfiguration.getFilePath());
                if (this.bufferFile.getParent() != null) {
                    this.bufferFile.getParentFile().mkdirs();
                }
            } else {
                this.bufferFile = new File(DEFAULT_FILE_NAME);
            }
            try {
                this.queue = new BigQueuePersistentQueue(this.bufferFile.getName(), this.bufferFile.getParent());
            }
            catch (IOException e) {
                LOGGER.error("There was an error while creating the disk buffering queue:", (Throwable)e);
                throw new BufferException("There was an error while creating the disk buffering queue.", (Throwable)e);
            }
        }
    }

    public void clean() {
        this.getFileObjectQueue().clear();
    }

    public void push(T t) {
        this.getFileObjectQueue().add(t);
    }

    public void pushAll(Collection<T> messages) {
        this.getFileObjectQueue().addAll(messages);
    }

    public Collection<T> get() {
        return this.getFileObjectQueue().pollAll();
    }

    public long getSize() {
        return this.getFileObjectQueue().size();
    }

    public void removeFile() throws BufferException, IOException {
        if (this.bufferFile != null) {
            FileUtils.deleteDirectory((File)this.bufferFile);
        }
        this.bufferFile = null;
        this.queue = null;
    }

    private PersistentQueue<T> getFileObjectQueue() {
        return this.queue;
    }
}

