/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.handlers.internal.buffer.impl;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.leansoft.bigqueue.BigQueueImpl;
import com.mulesoft.agent.handlers.internal.buffer.impl.PersistentQueue;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.apache.commons.collections4.queue.SynchronizedQueue;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BigQueuePersistentQueue<T extends Serializable>
implements PersistentQueue<T> {
    private static final Logger LOGGER = LogManager.getLogger(BigQueuePersistentQueue.class);
    private final Kryo kryo;
    private static final int DEFAULT_DISK_CLEANING_FREQUENCY = 5000;
    private static final String DISK_CLEANING_FREQUENCY_KEY = "agent.big.queue.disk.cleaning.frequency";
    private static final int DEFAULT_DISK_BUFFER_MAX_FLUSHING_SIZE_KEY = 10000;
    private static final String DISK_BUFFER_MAX_FLUSHING_SIZE_KEY = "agent.disk.buffering.max.flushing.size";
    private static final int DEFAULT_MEMORY_BUFFER_SIZE = 10000;
    private static final String MEMORY_BUFFER_SIZE_KEY = "agent.disk.buffering.cache.size";
    private static final int DEFAULT_MEMORY_BUFFER_FLUSH_FREQUENCY = 500;
    private static final String MEMORY_BUFFER_FLUSH_FREQUENCY_KEY = "agent.disk.buffering.cache.flush.frequency";
    private final BigQueueImpl queueToFile;
    private Queue<T> memoryBuffer;
    private final ThreadFactory bigQueueCleanerThreadFactory = new BasicThreadFactory.Builder().namingPattern("bigqueue-cleaner-%d").build();
    private final ThreadFactory memoryBufferFlushThreadFactory = new BasicThreadFactory.Builder().namingPattern("memory-buffer-flush-%d").build();
    private ScheduledExecutorService scheduledExecutorService;
    private ScheduledExecutorService cacheFlushingExecutorService;
    private Object lock = new Object();

    public BigQueuePersistentQueue(@NotNull String queueFileName, @NotNull String queueFileDir) throws IOException {
        LOGGER.info("Creating the queue: '{}'.", (Object)new File(queueFileDir, queueFileName).getAbsolutePath());
        this.kryo = new Kryo();
        this.kryo.setRegistrationRequired(false);
        this.queueToFile = new BigQueueImpl(queueFileDir, queueFileName);
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(this.bigQueueCleanerThreadFactory);
        this.scheduledExecutorService.scheduleAtFixedRate(this::diskCleaner, this.getDiskCleaningFrequency(), this.getDiskCleaningFrequency(), TimeUnit.MILLISECONDS);
        this.memoryBuffer = SynchronizedQueue.synchronizedQueue((Queue)new CircularFifoQueue(this.getCacheSize()));
        this.cacheFlushingExecutorService = Executors.newSingleThreadScheduledExecutor(this.memoryBufferFlushThreadFactory);
        this.cacheFlushingExecutorService.scheduleAtFixedRate(this::flushToDisk, this.getCacheFlushingFrequency(), this.getCacheFlushingFrequency(), TimeUnit.MILLISECONDS);
    }

    private int getCacheSize() {
        return Integer.valueOf(System.getProperty(MEMORY_BUFFER_SIZE_KEY, String.valueOf(10000)));
    }

    private int getDiskCleaningFrequency() {
        return Integer.valueOf(System.getProperty(DISK_CLEANING_FREQUENCY_KEY, String.valueOf(5000)));
    }

    private long getCacheFlushingFrequency() {
        return Long.valueOf(System.getProperty(MEMORY_BUFFER_FLUSH_FREQUENCY_KEY, String.valueOf(500)));
    }

    private long getMaxFlushingSize() {
        return Long.valueOf(System.getProperty(DISK_BUFFER_MAX_FLUSHING_SIZE_KEY, String.valueOf(10000)));
    }

    private void flushToDisk() {
        try {
            for (int size = this.memoryBuffer.size(); size > 0; --size) {
                this.addToDiskQueue((Serializable)this.memoryBuffer.remove());
            }
        }
        catch (Throwable t) {
            LOGGER.error("Flush to Disk Runnable throws exception:", t);
        }
    }

    private void diskCleaner() {
        try {
            LOGGER.debug("Reclaiming free disk space. Queue size: '{}'.", (Object)this.queueToFile.size());
            long originalFreeSpace = new File("/").getFreeSpace();
            this.queueToFile.gc();
            long currentFreeSpace = new File("/").getFreeSpace();
            LOGGER.debug(String.format("Before cleaning up: '%d', current free space: '%d'. Recovered space: '%d'.", originalFreeSpace, currentFreeSpace, currentFreeSpace - originalFreeSpace));
        }
        catch (Throwable t) {
            LOGGER.error("Unhandled exception cleaning the disk.", t);
        }
    }

    @Override
    public long size() {
        return this.queueToFile.size();
    }

    @Override
    public boolean isEmpty() {
        return this.queueToFile.isEmpty();
    }

    @Override
    public boolean add(@NotNull T item) {
        return this.memoryBuffer.add(item);
    }

    @Override
    public boolean addAll(@NotNull Collection<T> items) {
        Boolean result = true;
        for (Serializable item : items) {
            result = result & this.addToDiskQueue(item);
        }
        return result;
    }

    private boolean addToDiskQueue(@NotNull T item) {
        try {
            this.queueToFile.enqueue(this.serialize(item));
            return true;
        }
        catch (IOException e) {
            LOGGER.error("There was an error adding the object {} to the queue.", item, (Object)e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void clear() {
        try {
            this.memoryBuffer.clear();
            this.queueToFile.removeAll();
        }
        catch (IOException e) {
            LOGGER.error("There was an error removing all the items from the queue.", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    public T poll() {
        try {
            return this.deserialize(this.queueToFile.dequeue());
        }
        catch (IOException e) {
            LOGGER.error("There was an error polling the object from the queue.", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<T> pollAll() {
        CircularFifoQueue elems = new CircularFifoQueue();
        Object object = this.lock;
        synchronized (object) {
            Long amount = Math.min(this.size(), this.getMaxFlushingSize());
            if (amount > 0L) {
                elems = new CircularFifoQueue(amount.intValue());
                while (amount > 0L) {
                    elems.add(this.poll());
                    Long l = amount;
                    Long l2 = amount = Long.valueOf(amount - 1L);
                }
            }
        }
        return elems;
    }

    @Override
    public T peek() {
        try {
            return this.deserialize(this.queueToFile.peek());
        }
        catch (Exception e) {
            LOGGER.error("There was an error peeking an object from the queue.", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private byte[] serialize(T object) {
        try (Output output = new Output(1024, -1);){
            this.kryo.reset();
            this.kryo.writeClassAndObject(output, object);
            byte[] byArray = output.toBytes();
            return byArray;
        }
    }

    private T deserialize(byte[] serialized) {
        try (Input input = new Input(serialized);){
            Serializable serializable = (Serializable)this.kryo.readClassAndObject(input);
            return (T)serializable;
        }
    }
}

